/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.domain.OfferInfo;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.OrderServiceImpl;
import org.broadleafcommerce.core.order.service.call.BundleOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.DiscreteOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.MergeCartResponse;
import org.broadleafcommerce.core.order.service.call.ReconstructCartResponse;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Service;

@Service(value="blCartService")
@ManagedResource(objectName="org.broadleafcommerce:name=CartService", description="Cart Service", currencyTimeLimit=15)
public class CartServiceImpl
extends OrderServiceImpl
implements CartService {
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blOfferService")
    protected OfferService offerService;
    protected boolean moveNamedOrderItems = true;
    protected boolean deleteEmptyNamedOrders = true;

    @Override
    public Order createNewCartForCustomer(Customer customer) {
        return this.orderDao.createNewCartForCustomer(customer);
    }

    @Override
    public Order findCartForCustomer(Customer customer) {
        return this.orderDao.readCartForCustomer(customer);
    }

    @Override
    public Order addAllItemsToCartFromNamedOrder(Order namedOrder) throws PricingException {
        return this.addAllItemsToCartFromNamedOrder(namedOrder, true);
    }

    @Override
    public Order addAllItemsToCartFromNamedOrder(Order namedOrder, boolean priceOrder) throws PricingException {
        Order cartOrder = this.orderDao.readCartForCustomer(namedOrder.getCustomer());
        if (cartOrder == null) {
            cartOrder = this.createNewCartForCustomer(namedOrder.getCustomer());
        }
        ArrayList<OrderItem> items = new ArrayList<OrderItem>(namedOrder.getOrderItems());
        for (int i = 0; i < items.size(); ++i) {
            OrderItem orderItem = (OrderItem)items.get(i);
            if (this.moveNamedOrderItems) {
                this.moveItemToOrder(namedOrder, cartOrder, orderItem, priceOrder);
                continue;
            }
            this.addOrderItemToOrder(cartOrder, orderItem, priceOrder);
        }
        return cartOrder;
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Long customerId, String orderName, Long orderItemId, Integer quantity) throws PricingException {
        return this.moveItemToCartFromNamedOrder(customerId, orderName, orderItemId, quantity, true);
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Long customerId, String orderName, Long orderItemId, Integer quantity, boolean priceOrder) throws PricingException {
        Order wishlistOrder = this.findNamedOrderForCustomer(orderName, this.customerService.createCustomerFromId(customerId));
        OrderItem orderItem = this.orderItemService.readOrderItemById(orderItemId);
        orderItem.setQuantity(quantity);
        return this.moveItemToCartFromNamedOrder(wishlistOrder, orderItem, priceOrder);
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Order namedOrder, OrderItem orderItem) throws PricingException {
        return this.moveItemToCartFromNamedOrder(namedOrder, orderItem, true);
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Order namedOrder, OrderItem orderItem, boolean priceOrder) throws PricingException {
        Order cartOrder = this.orderDao.readCartForCustomer(namedOrder.getCustomer());
        if (cartOrder == null) {
            cartOrder = this.createNewCartForCustomer(namedOrder.getCustomer());
        }
        if (this.moveNamedOrderItems) {
            this.moveItemToOrder(namedOrder, cartOrder, orderItem, priceOrder);
            if (namedOrder.getOrderItems().size() == 0 && this.deleteEmptyNamedOrders) {
                this.cancelOrder(namedOrder);
            }
        } else {
            orderItem = this.addOrderItemToOrder(cartOrder, orderItem, priceOrder);
        }
        return orderItem;
    }

    @Override
    public Order moveAllItemsToCartFromNamedOrder(Order namedOrder) throws PricingException {
        return this.moveAllItemsToCartFromNamedOrder(namedOrder, true);
    }

    @Override
    public Order moveAllItemsToCartFromNamedOrder(Order namedOrder, boolean priceOrder) throws PricingException {
        Order cartOrder = this.addAllItemsToCartFromNamedOrder(namedOrder, priceOrder);
        if (this.deleteEmptyNamedOrders) {
            this.cancelOrder(namedOrder);
        }
        return cartOrder;
    }

    @Override
    public MergeCartResponse mergeCart(Customer customer, Order anonymousCart) throws PricingException {
        return this.mergeCart(customer, anonymousCart, true);
    }

    @Override
    public MergeCartResponse mergeCart(Customer customer, Order anonymousCart, boolean priceOrder) throws PricingException {
        MergeCartResponse mergeCartResponse = new MergeCartResponse();
        ReconstructCartResponse reconstructCartResponse = this.reconstructCart(customer, priceOrder);
        mergeCartResponse.setRemovedItems(reconstructCartResponse.getRemovedItems());
        Order customerCart = reconstructCartResponse.getOrder();
        if (anonymousCart != null && customerCart != null && anonymousCart.getId().equals(customerCart.getId())) {
            mergeCartResponse.setMerged(false);
        } else {
            mergeCartResponse.setMerged(customerCart != null && customerCart.getOrderItems().size() > 0);
        }
        if (!(anonymousCart == null || customerCart != null && customerCart.getId().equals(anonymousCart.getId()) || anonymousCart == null || anonymousCart.getOrderItems() == null || anonymousCart.getOrderItems().isEmpty())) {
            if (customerCart == null) {
                customerCart = this.createNewCartForCustomer(customer);
            }
            for (OrderItem orderItem : anonymousCart.getOrderItems()) {
                if (orderItem instanceof DiscreteOrderItem) {
                    orderItem.removeAllAdjustments();
                    orderItem.removeAllCandidateItemOffers();
                    DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)orderItem;
                    if (discreteOrderItem.getSku().isActive(discreteOrderItem.getProduct(), orderItem.getCategory())) {
                        DiscreteOrderItemRequest itemRequest = this.createDiscreteOrderItemRequest(discreteOrderItem);
                        this.addDiscreteItemToOrder(customerCart, itemRequest, priceOrder);
                        mergeCartResponse.getAddedItems().add(orderItem);
                        continue;
                    }
                    mergeCartResponse.getRemovedItems().add(orderItem);
                    continue;
                }
                if (!(orderItem instanceof BundleOrderItem)) continue;
                BundleOrderItem bundleOrderItem = (BundleOrderItem)orderItem;
                orderItem.removeAllAdjustments();
                orderItem.removeAllCandidateItemOffers();
                boolean removeBundle = false;
                ArrayList<DiscreteOrderItemRequest> discreteOrderItemRequests = new ArrayList<DiscreteOrderItemRequest>();
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    discreteOrderItem.removeAllAdjustments();
                    discreteOrderItem.removeAllCandidateItemOffers();
                    DiscreteOrderItemRequest itemRequest = this.createDiscreteOrderItemRequest(discreteOrderItem);
                    discreteOrderItemRequests.add(itemRequest);
                    if (discreteOrderItem.getSku().isActive(discreteOrderItem.getProduct(), orderItem.getCategory())) continue;
                    removeBundle = true;
                }
                BundleOrderItemRequest bundleOrderItemRequest = this.createBundleOrderItemRequest(bundleOrderItem, discreteOrderItemRequests);
                if (!removeBundle) {
                    this.addBundleItemToOrder(customerCart, bundleOrderItemRequest, priceOrder);
                    mergeCartResponse.getAddedItems().add(orderItem);
                    continue;
                }
                mergeCartResponse.getRemovedItems().add(orderItem);
            }
            HashMap<String, OfferCode> customerOffersMap = new HashMap<String, OfferCode>();
            for (OfferCode customerOffer : customerCart.getAddedOfferCodes()) {
                customerOffersMap.put(customerOffer.getOfferCode(), customerOffer);
            }
            for (OfferCode anonymousOffer : anonymousCart.getAddedOfferCodes()) {
                if (customerOffersMap.containsKey(anonymousOffer.getOfferCode())) continue;
                OfferCode transferredCode = this.offerService.lookupOfferCodeByCode(anonymousOffer.getOfferCode());
                OfferInfo info = anonymousCart.getAdditionalOfferInformation().get(anonymousOffer.getOffer());
                OfferInfo offerInfo = this.offerDao.createOfferInfo();
                for (String key : info.getFieldValues().keySet()) {
                    offerInfo.getFieldValues().put(key, info.getFieldValues().get(key));
                }
                customerCart.getAdditionalOfferInformation().put(transferredCode.getOffer(), offerInfo);
                customerCart.addOfferCode(transferredCode);
            }
            customerCart = this.save(customerCart, true);
            this.cancelOrder(anonymousCart);
        }
        mergeCartResponse.setOrder(customerCart);
        return mergeCartResponse;
    }

    @Override
    public ReconstructCartResponse reconstructCart(Customer customer) throws PricingException {
        return this.reconstructCart(customer, true);
    }

    @Override
    public ReconstructCartResponse reconstructCart(Customer customer, boolean priceOrder) throws PricingException {
        ReconstructCartResponse reconstructCartResponse = new ReconstructCartResponse();
        Order customerCart = this.findCartForCustomer(customer);
        if (customerCart != null) {
            ArrayList<OrderItem> itemsToRemove = new ArrayList<OrderItem>();
            for (OrderItem orderItem : customerCart.getOrderItems()) {
                if (orderItem instanceof DiscreteOrderItem) {
                    DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)orderItem;
                    if (discreteOrderItem.getSku().isActive(discreteOrderItem.getProduct(), orderItem.getCategory())) continue;
                    itemsToRemove.add(orderItem);
                    continue;
                }
                if (!(orderItem instanceof BundleOrderItem)) continue;
                BundleOrderItem bundleOrderItem = (BundleOrderItem)orderItem;
                boolean removeBundle = false;
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    if (discreteOrderItem.getSku().isActive(discreteOrderItem.getProduct(), orderItem.getCategory())) continue;
                    removeBundle = true;
                    break;
                }
                if (!removeBundle) continue;
                itemsToRemove.add(orderItem);
            }
            for (OrderItem item : itemsToRemove) {
                this.removeItemFromOrder(customerCart, item, priceOrder);
            }
            reconstructCartResponse.setRemovedItems(itemsToRemove);
        }
        reconstructCartResponse.setOrder(customerCart);
        return reconstructCartResponse;
    }

    @Override
    @ManagedAttribute(description="The move item from named order when adding to the cart attribute", currencyTimeLimit=15)
    public boolean isMoveNamedOrderItems() {
        return this.moveNamedOrderItems;
    }

    @Override
    @ManagedAttribute(description="The move item from named order when adding to the cart attribute", currencyTimeLimit=15)
    public void setMoveNamedOrderItems(boolean moveNamedOrderItems) {
        this.moveNamedOrderItems = moveNamedOrderItems;
    }

    @Override
    @ManagedAttribute(description="The delete empty named order after adding items to cart attribute", currencyTimeLimit=15)
    public boolean isDeleteEmptyNamedOrders() {
        return this.deleteEmptyNamedOrders;
    }

    @Override
    @ManagedAttribute(description="The delete empty named order after adding items to cart attribute", currencyTimeLimit=15)
    public void setDeleteEmptyNamedOrders(boolean deleteEmptyNamedOrders) {
        this.deleteEmptyNamedOrders = deleteEmptyNamedOrders;
    }
}

