/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.broadleafcommerce.core.order.service.manipulation.OrderItemVisitor;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_GIFTWRAP_ORDER_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationClass(friendlyName="giftWrapOrderItem")
public class GiftWrapOrderItemImpl
extends DiscreteOrderItemImpl
implements GiftWrapOrderItem {
    private static final long serialVersionUID = 1L;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="giftWrapOrderItem", targetEntity=OrderItemImpl.class, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<OrderItem> wrappedItems = new ArrayList<OrderItem>();

    @Override
    public List<OrderItem> getWrappedItems() {
        return this.wrappedItems;
    }

    @Override
    public void setWrappedItems(List<OrderItem> wrappedItems) {
        this.wrappedItems = wrappedItems;
    }

    @Override
    public OrderItem clone() {
        GiftWrapOrderItem orderItem = (GiftWrapOrderItem)super.clone();
        if (this.getWrappedItems() != null) {
            orderItem.getWrappedItems().addAll(this.getWrappedItems());
        }
        return orderItem;
    }

    @Override
    public int hashCode() {
        int prime = super.hashCode();
        int result = super.hashCode();
        result = prime * result + (this.wrappedItems == null ? 0 : ((Object)this.wrappedItems).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GiftWrapOrderItemImpl other = (GiftWrapOrderItemImpl)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.wrappedItems == null ? other.wrappedItems != null : !((Object)this.wrappedItems).equals(other.wrappedItems));
    }

    @Override
    public void accept(OrderItemVisitor visitor) throws PricingException {
        visitor.visit(this);
    }
}

