/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;

@Entity
@DiscriminatorColumn(name="TYPE")
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_GROUP_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class FulfillmentGroupItemImpl
implements FulfillmentGroupItem {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FulfillmentGroupItemId", strategy=GenerationType.TABLE)
    @TableGenerator(name="FulfillmentGroupItemId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="FulfillmentGroupItemImpl", allocationSize=50)
    @Column(name="FULFILLMENT_GROUP_ITEM_ID")
    protected Long id;
    @ManyToOne(targetEntity=FulfillmentGroupImpl.class, optional=false)
    @JoinColumn(name="FULFILLMENT_GROUP_ID")
    @Index(name="FGITEM_FG_INDEX", columnNames={"FULFILLMENT_GROUP_ID"})
    protected FulfillmentGroup fulfillmentGroup;
    @OneToOne(targetEntity=OrderItemImpl.class, optional=false)
    @JoinColumn(name="ORDER_ITEM_ID")
    protected OrderItem orderItem;
    @Column(name="QUANTITY", nullable=false)
    protected int quantity;
    @Column(name="STATUS")
    @Index(name="FGITEM_STATUS_INDEX", columnNames={"STATUS"})
    private String status;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public FulfillmentGroup getFulfillmentGroup() {
        return this.fulfillmentGroup;
    }

    @Override
    public void setFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        this.fulfillmentGroup = fulfillmentGroup;
    }

    @Override
    public OrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Override
    public Money getRetailPrice() {
        return this.orderItem.getRetailPrice();
    }

    @Override
    public Money getSalePrice() {
        return this.orderItem.getSalePrice();
    }

    @Override
    public Money getPrice() {
        return this.orderItem.getPrice();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void removeAssociations() {
        if (this.getFulfillmentGroup() != null) {
            this.getFulfillmentGroup().getFulfillmentGroupItems().remove(this);
        }
        this.setFulfillmentGroup(null);
        this.setOrderItem(null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentGroupItemImpl other = (FulfillmentGroupItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.orderItem == null ? other.orderItem != null : !this.orderItem.equals(other.orderItem));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.orderItem == null ? 0 : this.orderItem.hashCode());
        return result;
    }
}

