/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@DiscriminatorColumn(name="TYPE")
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_GROUP_FEE")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class FulfillmentGroupFeeImpl
implements FulfillmentGroupFee {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FulfillmentGroupFeeId", strategy=GenerationType.TABLE)
    @TableGenerator(name="FulfillmentGroupFeeId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="FulfillmentGroupFeeImpl", allocationSize=50)
    @Column(name="FULFILLMENT_GROUP_FEE_ID")
    protected Long id;
    @ManyToOne(targetEntity=FulfillmentGroupImpl.class, optional=false)
    @JoinColumn(name="FULFILLMENT_GROUP_ID")
    protected FulfillmentGroup fulfillmentGroup;
    @Column(name="AMOUNT", precision=19, scale=5)
    protected BigDecimal amount;
    @Column(name="NAME")
    private String name;
    @Column(name="REPORTING_CODE")
    private String reportingCode;
    @Column(name="IS_TAXABLE")
    private Boolean isTaxable = Boolean.FALSE;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public FulfillmentGroup getFulfillmentGroup() {
        return this.fulfillmentGroup;
    }

    @Override
    public void setFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        this.fulfillmentGroup = fulfillmentGroup;
    }

    @Override
    public Money getAmount() {
        return this.amount == null ? null : new Money(this.amount);
    }

    @Override
    public void setAmount(Money amount) {
        this.amount = Money.toAmount((Money)amount);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Boolean isTaxable() {
        return this.isTaxable;
    }

    @Override
    public void setTaxable(Boolean isTaxable) {
        this.isTaxable = isTaxable;
    }

    @Override
    public String getReportingCode() {
        return this.reportingCode;
    }

    @Override
    public void setReportingCode(String reportingCode) {
        this.reportingCode = reportingCode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        result = 31 * result + (this.fulfillmentGroup == null ? 0 : this.fulfillmentGroup.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.isTaxable != false ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.reportingCode == null ? 0 : this.reportingCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentGroupFeeImpl other = (FulfillmentGroupFeeImpl)obj;
        if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
            return false;
        }
        if (this.fulfillmentGroup == null ? other.fulfillmentGroup != null : !this.fulfillmentGroup.equals(other.fulfillmentGroup)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.isTaxable != other.isTaxable) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.reportingCode == null ? other.reportingCode != null : !this.reportingCode.equals(other.reportingCode));
    }
}

