/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.discount.PromotionDiscount;
import org.broadleafcommerce.core.offer.service.discount.PromotionQualifier;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;

public class PromotableOrderItemImpl
implements PromotableOrderItem {
    private static final long serialVersionUID = 1L;
    protected BigDecimal retailAdjustmentPrice;
    protected BigDecimal saleAdjustmentPrice;
    protected List<PromotionDiscount> promotionDiscounts = new ArrayList<PromotionDiscount>();
    protected List<PromotionQualifier> promotionQualifiers = new ArrayList<PromotionQualifier>();
    protected DiscreteOrderItem delegate;
    protected PromotableOrder order;
    protected PromotableItemFactory itemFactory;

    public PromotableOrderItemImpl(DiscreteOrderItem orderItem, PromotableOrder order, PromotableItemFactory itemFactory) {
        this.delegate = orderItem;
        this.order = order;
        this.itemFactory = itemFactory;
    }

    @Override
    public DiscreteOrderItem getDelegate() {
        return this.delegate;
    }

    @Override
    public void reset() {
        this.delegate = null;
    }

    @Override
    public void assignFinalPrice() {
        this.delegate.setPrice(this.getCurrentPrice());
    }

    @Override
    public Money getCurrentPrice() {
        this.delegate.updatePrices();
        Money currentPrice = null;
        currentPrice = this.delegate.getIsOnSale() ? this.delegate.getSalePrice() : this.delegate.getRetailPrice();
        if (this.getRetailAdjustmentPrice() != null && this.getRetailAdjustmentPrice().lessThan(currentPrice)) {
            currentPrice = this.getRetailAdjustmentPrice();
        }
        if (this.getSaleAdjustmentPrice() != null && this.getSaleAdjustmentPrice().lessThan(currentPrice)) {
            currentPrice = this.getSaleAdjustmentPrice();
        }
        return currentPrice;
    }

    @Override
    public void computeAdjustmentPrice() {
        this.delegate.updatePrices();
        Money tempDiscountedRetailPrice = this.delegate.getRetailPrice();
        Money tempDiscountedSalePrice = this.delegate.getSalePrice();
        for (OrderItemAdjustment adjustment : this.delegate.getOrderItemAdjustments()) {
            Money salesValue = adjustment.getSalesPriceValue();
            Money retailValue = adjustment.getRetailPriceValue();
            if (adjustment.getOffer().getApplyDiscountToSalePrice() && adjustment.getOrderItem().getIsOnSale()) {
                tempDiscountedSalePrice = tempDiscountedSalePrice.subtract(salesValue);
            }
            tempDiscountedRetailPrice = tempDiscountedRetailPrice.subtract(retailValue);
        }
        if (tempDiscountedSalePrice != null) {
            this.saleAdjustmentPrice = tempDiscountedSalePrice.getAmount();
        }
        this.retailAdjustmentPrice = tempDiscountedRetailPrice.getAmount();
    }

    @Override
    public void addOrderItemAdjustment(PromotableOrderItemAdjustment orderItemAdjustment) {
        orderItemAdjustment.computeAdjustmentValues();
        this.delegate.getOrderItemAdjustments().add(orderItemAdjustment.getDelegate());
        this.order.resetTotalitarianOfferApplied();
        this.computeAdjustmentPrice();
    }

    @Override
    public int removeAllAdjustments() {
        int removedAdjustmentCount = this.delegate.removeAllAdjustments();
        this.retailAdjustmentPrice = null;
        this.saleAdjustmentPrice = null;
        this.order.resetTotalitarianOfferApplied();
        if (this.promotionDiscounts != null) {
            this.promotionDiscounts.clear();
        }
        if (this.promotionQualifiers != null) {
            this.promotionQualifiers.clear();
        }
        this.assignFinalPrice();
        return removedAdjustmentCount;
    }

    @Override
    public Money getRetailAdjustmentPrice() {
        return this.retailAdjustmentPrice == null ? null : new Money(this.retailAdjustmentPrice, this.delegate.getRetailPrice().getCurrency(), this.retailAdjustmentPrice.scale() == 0 ? 2 : this.retailAdjustmentPrice.scale());
    }

    @Override
    public void setRetailAdjustmentPrice(Money retailAdjustmentPrice) {
        this.retailAdjustmentPrice = Money.toAmount((Money)retailAdjustmentPrice);
    }

    @Override
    public Money getSaleAdjustmentPrice() {
        return this.saleAdjustmentPrice == null ? null : new Money(this.saleAdjustmentPrice, this.delegate.getRetailPrice().getCurrency(), this.saleAdjustmentPrice.scale() == 0 ? 2 : this.saleAdjustmentPrice.scale());
    }

    @Override
    public void setSaleAdjustmentPrice(Money saleAdjustmentPrice) {
        this.saleAdjustmentPrice = Money.toAmount((Money)saleAdjustmentPrice);
    }

    @Override
    public boolean isNotCombinableOfferApplied() {
        for (OrderItemAdjustment orderItemAdjustment : this.delegate.getOrderItemAdjustments()) {
            boolean notCombineableApplied = !orderItemAdjustment.getOffer().isCombinableWithOtherOffers() || orderItemAdjustment.getOffer().isTotalitarianOffer() != null && orderItemAdjustment.getOffer().isTotalitarianOffer() != false;
            if (!notCombineableApplied) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHasOrderItemAdjustments() {
        return this.delegate.getOrderItemAdjustments() != null && this.delegate.getOrderItemAdjustments().size() > 0;
    }

    @Override
    public List<PromotionDiscount> getPromotionDiscounts() {
        return this.promotionDiscounts;
    }

    @Override
    public void setPromotionDiscounts(List<PromotionDiscount> promotionDiscounts) {
        this.promotionDiscounts = promotionDiscounts;
    }

    @Override
    public List<PromotionQualifier> getPromotionQualifiers() {
        return this.promotionQualifiers;
    }

    @Override
    public void setPromotionQualifiers(List<PromotionQualifier> promotionQualifiers) {
        this.promotionQualifiers = promotionQualifiers;
    }

    @Override
    public int getQuantityAvailableToBeUsedAsQualifier(Offer promotion) {
        OfferItemRestrictionRuleType qualifierType;
        int qtyAvailable = this.delegate.getQuantity();
        for (PromotionDiscount promotionDiscount : this.promotionDiscounts) {
            if (promotionDiscount.getPromotion().equals(promotion)) {
                qtyAvailable -= promotionDiscount.getQuantity();
                continue;
            }
            qualifierType = promotionDiscount.getPromotion().getOfferItemTargetRuleType();
            if (!OfferItemRestrictionRuleType.NONE.equals(qualifierType) && !OfferItemRestrictionRuleType.TARGET.equals(qualifierType)) continue;
            qtyAvailable -= promotionDiscount.getQuantity();
        }
        for (PromotionQualifier promotionQualifier : this.promotionQualifiers) {
            if (promotionQualifier.getPromotion().equals(promotion)) {
                qtyAvailable -= promotionQualifier.getQuantity();
                continue;
            }
            qualifierType = promotionQualifier.getPromotion().getOfferItemQualifierRuleType();
            if (!OfferItemRestrictionRuleType.NONE.equals(qualifierType) && !OfferItemRestrictionRuleType.TARGET.equals(qualifierType)) continue;
            qtyAvailable -= promotionQualifier.getQuantity();
        }
        return qtyAvailable;
    }

    @Override
    public int getQuantityAvailableToBeUsedAsTarget(Offer promotion) {
        OfferItemRestrictionRuleType qualifierType;
        int qtyAvailable = this.delegate.getQuantity();
        boolean stackable = promotion.isStackable();
        for (PromotionDiscount promotionDiscount : this.promotionDiscounts) {
            if (promotionDiscount.getPromotion().equals(promotion) || !stackable) {
                qtyAvailable -= promotionDiscount.getQuantity();
                continue;
            }
            if (!promotionDiscount.getPromotion().isStackable() || !OfferItemRestrictionRuleType.NONE.equals(qualifierType = promotionDiscount.getPromotion().getOfferItemTargetRuleType()) && !OfferItemRestrictionRuleType.QUALIFIER.equals(qualifierType)) continue;
            qtyAvailable -= promotionDiscount.getQuantity();
        }
        for (PromotionQualifier promotionQualifier : this.promotionQualifiers) {
            if (promotionQualifier.getPromotion().equals(promotion)) {
                qtyAvailable -= promotionQualifier.getQuantity();
                continue;
            }
            qualifierType = promotionQualifier.getPromotion().getOfferItemQualifierRuleType();
            if (!OfferItemRestrictionRuleType.NONE.equals(qualifierType) && !OfferItemRestrictionRuleType.QUALIFIER.equals(qualifierType)) continue;
            qtyAvailable -= promotionQualifier.getQuantity();
        }
        return qtyAvailable;
    }

    @Override
    public void addPromotionQualifier(PromotableCandidateItemOffer candidatePromotion, OfferItemCriteria itemCriteria, int quantity) {
        PromotionQualifier pq = this.lookupOrCreatePromotionQualifier(candidatePromotion);
        pq.incrementQuantity(quantity);
        pq.setItemCriteria(itemCriteria);
    }

    @Override
    public void addPromotionDiscount(PromotableCandidateItemOffer candidatePromotion, OfferItemCriteria itemCriteria, int quantity) {
        PromotionDiscount pd = this.lookupOrCreatePromotionDiscount(candidatePromotion);
        if (pd == null) {
            return;
        }
        pd.incrementQuantity(quantity);
        pd.setItemCriteria(itemCriteria);
        pd.setCandidateItemOffer(candidatePromotion);
        candidatePromotion.addUse();
    }

    @Override
    public PromotionQualifier lookupOrCreatePromotionQualifier(PromotableCandidateItemOffer candidatePromotion) {
        Offer promotion = candidatePromotion.getOffer();
        for (PromotionQualifier pq : this.promotionQualifiers) {
            if (!pq.getPromotion().equals(promotion)) continue;
            return pq;
        }
        PromotionQualifier pq = new PromotionQualifier();
        pq.setPromotion(promotion);
        this.promotionQualifiers.add(pq);
        return pq;
    }

    @Override
    public PromotionDiscount lookupOrCreatePromotionDiscount(PromotableCandidateItemOffer candidatePromotion) {
        Offer promotion = candidatePromotion.getOffer();
        for (PromotionDiscount pd : this.promotionDiscounts) {
            if (!pd.getPromotion().equals(promotion)) continue;
            return pd;
        }
        PromotionDiscount pd = new PromotionDiscount();
        pd.setPromotion(promotion);
        this.promotionDiscounts.add(pd);
        return pd;
    }

    @Override
    public void clearAllNonFinalizedQuantities() {
        this.clearAllNonFinalizedDiscounts();
        this.clearAllNonFinalizedQualifiers();
    }

    @Override
    public void clearAllDiscount() {
        this.promotionDiscounts.clear();
    }

    @Override
    public void clearAllQualifiers() {
        this.promotionQualifiers.clear();
    }

    @Override
    public void clearAllNonFinalizedDiscounts() {
        Iterator<PromotionDiscount> promotionDiscountIterator = this.promotionDiscounts.iterator();
        while (promotionDiscountIterator.hasNext()) {
            PromotionDiscount promotionDiscount = promotionDiscountIterator.next();
            if (promotionDiscount.getFinalizedQuantity() == 0) {
                promotionDiscountIterator.remove();
                continue;
            }
            promotionDiscount.setQuantity(promotionDiscount.getFinalizedQuantity());
        }
    }

    @Override
    public void clearAllNonFinalizedQualifiers() {
        Iterator<PromotionQualifier> promotionQualifierIterator = this.promotionQualifiers.iterator();
        while (promotionQualifierIterator.hasNext()) {
            PromotionQualifier promotionQualifier = promotionQualifierIterator.next();
            if (promotionQualifier.getFinalizedQuantity() == 0) {
                promotionQualifierIterator.remove();
                continue;
            }
            promotionQualifier.setQuantity(promotionQualifier.getFinalizedQuantity());
        }
    }

    @Override
    public void finalizeQuantities() {
        for (PromotionDiscount promotionDiscount : this.promotionDiscounts) {
            promotionDiscount.setFinalizedQuantity(promotionDiscount.getQuantity());
        }
        for (PromotionQualifier promotionQualifier : this.promotionQualifiers) {
            promotionQualifier.setFinalizedQuantity(promotionQualifier.getQuantity());
        }
    }

    @Override
    public int getPromotionDiscountMismatchQuantity() {
        for (PromotionDiscount promotionDiscount : this.promotionDiscounts) {
            if (promotionDiscount.getQuantity() == this.delegate.getQuantity()) continue;
            return promotionDiscount.getQuantity();
        }
        return 0;
    }

    @Override
    public List<PromotableOrderItem> split() {
        int discountQty;
        ArrayList<PromotableOrderItem> splitItems = null;
        if (this.delegate.getQuantity() != 1 && (discountQty = this.getPromotionDiscountMismatchQuantity()) != 0) {
            splitItems = new ArrayList<PromotableOrderItem>();
            PromotableOrderItem firstItem = this.clone();
            PromotableOrderItem secondItem = this.clone();
            splitItems.add(firstItem);
            splitItems.add(secondItem);
            int firstItemQty = discountQty;
            int secondItemQty = this.delegate.getQuantity() - discountQty;
            firstItem.getDelegate().setQuantity(firstItemQty);
            secondItem.getDelegate().setQuantity(secondItemQty);
            for (PromotionQualifier pq : this.promotionQualifiers) {
                if (pq.getQuantity() > firstItemQty) {
                    PromotionQualifier pq1 = pq.copy();
                    pq1.resetQty(firstItemQty);
                    firstItem.getPromotionQualifiers().add(pq1);
                    PromotionQualifier pq2 = pq.copy();
                    pq2.resetQty(pq.getQuantity() - firstItemQty);
                    secondItem.getPromotionQualifiers().add(pq2);
                    continue;
                }
                firstItem.getPromotionQualifiers().add(pq);
            }
            for (PromotionDiscount pd : this.promotionDiscounts) {
                if (pd.getQuantity() > firstItemQty) {
                    PromotionDiscount pd1 = pd.copy();
                    pd1.resetQty(firstItemQty);
                    firstItem.getPromotionDiscounts().add(pd1);
                    PromotionDiscount pd2 = pd.copy();
                    pd2.resetQty(pd.getQuantity() - firstItemQty);
                    secondItem.getPromotionDiscounts().add(pd2);
                    continue;
                }
                firstItem.getPromotionDiscounts().add(pd);
            }
        }
        return splitItems;
    }

    @Override
    public int getQuantity() {
        return this.delegate.getQuantity();
    }

    @Override
    public void setQuantity(int quantity) {
        this.delegate.setQuantity(quantity);
    }

    @Override
    public Sku getSku() {
        return this.delegate.getSku();
    }

    @Override
    public Money getPriceBeforeAdjustments(boolean allowSalesPrice) {
        return this.delegate.getPriceBeforeAdjustments(allowSalesPrice);
    }

    @Override
    public Money getSalePrice() {
        return this.delegate.getSalePrice();
    }

    @Override
    public Money getRetailPrice() {
        return this.delegate.getRetailPrice();
    }

    @Override
    public void addCandidateItemOffer(PromotableCandidateItemOffer candidateItemOffer) {
        this.delegate.addCandidateItemOffer(candidateItemOffer.getDelegate());
    }

    @Override
    public PromotableOrderItem clone() {
        PromotableOrderItem copy = this.itemFactory.createPromotableOrderItem((DiscreteOrderItem)this.delegate.clone(), this.order);
        copy.setRetailAdjustmentPrice(this.getRetailAdjustmentPrice());
        copy.setSaleAdjustmentPrice(this.getSaleAdjustmentPrice());
        return copy;
    }

    @Override
    public int fixAdjustments(boolean useSaleAdjustments) {
        Iterator<OrderItemAdjustment> adjustmentsIterator = this.delegate.getOrderItemAdjustments().iterator();
        int removeCount = 0;
        while (adjustmentsIterator.hasNext()) {
            OrderItemAdjustment currentAdjustment = adjustmentsIterator.next();
            if (useSaleAdjustments) {
                if (currentAdjustment.getSalesPriceValue().lessThanOrEqual(BigDecimal.ZERO)) {
                    currentAdjustment.setOrderItem(null);
                    adjustmentsIterator.remove();
                    ++removeCount;
                    continue;
                }
                currentAdjustment.setAppliedToSalePrice(true);
                currentAdjustment.setValue(currentAdjustment.getSalesPriceValue());
                continue;
            }
            if (currentAdjustment.getRetailPriceValue().lessThanOrEqual(BigDecimal.ZERO)) {
                currentAdjustment.setOrderItem(null);
                adjustmentsIterator.remove();
                ++removeCount;
                continue;
            }
            currentAdjustment.setAppliedToSalePrice(false);
            currentAdjustment.setValue(currentAdjustment.getRetailPriceValue());
        }
        return removeCount;
    }
}

