/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationOverride;
import org.broadleafcommerce.common.presentation.AdminPresentationOverrides;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_ITEM_ADJUSTMENT")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationOverrides(value={@AdminPresentationOverride(name="offer.id", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.description", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.discountType", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.value", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.priority", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.startDate", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.endDate", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.stackable", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.targetSystem", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.applyToSalePrice", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.appliesToOrderRules", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.appliesToCustomerRules", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.applyDiscountToMarkedItems", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.combinableWithOtherOffers", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.deliveryType", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.maxUses", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.uses", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.offerItemQualifierRuleType", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.offerItemTargetRuleType", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.targetItemCriteria", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.totalitarianOffer", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.treatAsNewFormat", value=@AdminPresentation(excluded=true))})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="baseOrderItemAdjustment")
public class OrderItemAdjustmentImpl
implements OrderItemAdjustment {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderItemAdjustmentId")
    @GenericGenerator(name="OrderItemAdjustmentId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="OrderItemAdjustmentImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.OrderItemAdjustmentImpl")})
    @Column(name="ORDER_ITEM_ADJUSTMENT_ID")
    protected Long id;
    @ManyToOne(targetEntity=OrderItemImpl.class)
    @JoinColumn(name="ORDER_ITEM_ID")
    @Index(name="OIADJUST_ITEM_INDEX", columnNames={"ORDER_ITEM_ID"})
    @AdminPresentation(excluded=true)
    protected OrderItem orderItem;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false)
    @JoinColumn(name="OFFER_ID")
    @Index(name="OIADJUST_OFFER_INDEX", columnNames={"OFFER_ID"})
    protected Offer offer;
    @Column(name="ADJUSTMENT_REASON", nullable=false)
    @AdminPresentation(friendlyName="Item Adjustment Reason", order=1, group="Description")
    protected String reason;
    @Column(name="ADJUSTMENT_VALUE", nullable=false)
    @AdminPresentation(friendlyName="Item Adjustment Value", order=2, group="Description")
    protected BigDecimal value = Money.ZERO.getAmount();
    @Column(name="APPLIED_TO_SALE_PRICE")
    @AdminPresentation(friendlyName="Apply To Sale Price", order=3, group="Description")
    protected boolean appliedToSalePrice;
    @Transient
    protected Money retailValue;
    @Transient
    protected Money salesValue;

    @Override
    public void init(OrderItem orderItem, Offer offer, String reason) {
        this.orderItem = orderItem;
        this.offer = offer;
        this.reason = reason;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public OrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    @Override
    public Money getValue() {
        return this.value == null ? null : new Money(this.value);
    }

    @Override
    public void setValue(Money value) {
        this.value = value.getAmount();
    }

    @Override
    public boolean isAppliedToSalePrice() {
        return this.appliedToSalePrice;
    }

    @Override
    public void setAppliedToSalePrice(boolean appliedToSalePrice) {
        this.appliedToSalePrice = appliedToSalePrice;
    }

    @Override
    public Money getRetailPriceValue() {
        if (this.salesValue == null) {
            return Money.ZERO;
        }
        return this.retailValue;
    }

    @Override
    public void setRetailPriceValue(Money retailPriceValue) {
        this.retailValue = retailPriceValue;
    }

    @Override
    public Money getSalesPriceValue() {
        if (this.salesValue == null) {
            return Money.ZERO;
        }
        return this.salesValue;
    }

    @Override
    public void setSalesPriceValue(Money salesPriceValue) {
        this.salesValue = salesPriceValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.offer == null ? 0 : this.offer.hashCode());
        result = 31 * result + (this.orderItem == null ? 0 : this.orderItem.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderItemAdjustmentImpl other = (OrderItemAdjustmentImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.offer == null ? other.offer != null : !this.offer.equals(other.offer)) {
            return false;
        }
        if (this.orderItem == null ? other.orderItem != null : !this.orderItem.equals(other.orderItem)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

