/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.inventory.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.util.dao.BatchRetrieveDao;
import org.broadleafcommerce.core.inventory.dao.AvailabilityDao;
import org.broadleafcommerce.core.inventory.domain.SkuAvailability;
import org.springframework.stereotype.Repository;

@Repository(value="blAvailabilityDao")
public class AvailabilityDaoImpl
extends BatchRetrieveDao
implements AvailabilityDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;

    @Override
    public List<SkuAvailability> readSKUAvailability(List<Long> skuIds, boolean realTime) {
        Query query = this.em.createNamedQuery("BC_READ_SKU_AVAILABILITIES_BY_SKU_IDS");
        if (!realTime) {
            query.setHint("org.hibernate.cacheable", (Object)true);
        }
        return this.batchExecuteReadQuery(query, skuIds, "skuIds");
    }

    @Override
    public List<SkuAvailability> readSKUAvailabilityForLocation(List<Long> skuIds, Long locationId, boolean realTime) {
        Query query = this.em.createNamedQuery("BC_READ_SKU_AVAILABILITIES_BY_LOCATION_ID_AND_SKU_IDS");
        if (!realTime) {
            query.setHint("org.hibernate.cacheable", (Object)true);
        }
        query.setParameter("locationId", (Object)locationId);
        return this.batchExecuteReadQuery(query, skuIds, "skuIds");
    }

    @Override
    public void save(SkuAvailability skuAvailability) {
        this.em.merge((Object)skuAvailability);
    }
}

