/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.content.dao;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.util.dao.BatchRetrieveDao;
import org.broadleafcommerce.core.content.dao.ContentDetailsDao;
import org.broadleafcommerce.core.content.domain.ContentDetails;
import org.springframework.stereotype.Repository;

@Repository(value="blContentDetailsDao")
public class ContentDetailsDaoImpl
extends BatchRetrieveDao
implements ContentDetailsDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public void delete(ContentDetails contentDetails) {
        if (!this.em.contains((Object)contentDetails)) {
            contentDetails = this.readContentDetailsById(contentDetails.getId());
        }
        this.em.remove((Object)contentDetails);
    }

    @Override
    public ContentDetails readContentDetailsById(Integer id) {
        return (ContentDetails)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.core.content.domain.ContentDetails"), (Object)id);
    }

    @Override
    public List<ContentDetails> readContentDetailsByOrderedIds(List<Integer> ids) {
        Query query = this.em.createNamedQuery("BC_READ_CONTENT_DETAILS_BY_IDS");
        List cds = this.batchExecuteReadQuery(query, ids, "contentIds");
        ArrayList<ContentDetails> orderedCds = new ArrayList<ContentDetails>();
        for (Integer id : ids) {
            for (ContentDetails cd : cds) {
                if (id.intValue() != cd.getId().intValue()) continue;
                orderedCds.add(cd);
            }
        }
        return orderedCds;
    }

    @Override
    public ContentDetails save(ContentDetails contentDetails) {
        return (ContentDetails)this.em.merge((Object)contentDetails);
    }
}

