/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.search.dao.SearchInterceptDao;
import org.broadleafcommerce.core.search.dao.SearchSynonymDao;
import org.broadleafcommerce.core.search.domain.SearchIntercept;
import org.broadleafcommerce.core.search.domain.SearchSynonym;
import org.broadleafcommerce.core.search.service.SearchService;
import org.compass.core.Compass;
import org.compass.core.CompassContext;
import org.compass.core.CompassDetachedHits;
import org.compass.core.CompassIndexSession;
import org.compass.core.CompassSearchSession;
import org.compass.core.engine.SearchEngineIndexManager;
import org.springframework.stereotype.Service;

@Service(value="blSearchService")
public class SearchServiceCompassImpl
implements SearchService {
    private static final Logger LOG = Logger.getLogger(SearchServiceCompassImpl.class);
    @CompassContext
    protected Compass compass;
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    @Resource(name="blSearchInterceptDao")
    protected SearchInterceptDao searchInterceptDao;
    @Resource(name="blSearchSynonymDao")
    protected SearchSynonymDao searchSynonymDao;

    @Override
    public List<Product> performSearch(String input) {
        CompassSearchSession session = this.compass.openSearchSession();
        CompassDetachedHits hits = session.find(input).detach();
        session.close();
        ArrayList<Product> results = new ArrayList<Product>(hits.length());
        for (int i = 0; i < hits.length(); ++i) {
            Product resourceProduct = (Product)hits.data(i);
            results.add(this.catalogService.findProductById(resourceProduct.getId()));
        }
        return results;
    }

    @Override
    public void rebuildProductIndex() {
        LOG.info((Object)"Rebuilding product index");
        List<Product> products = this.catalogService.findAllProducts();
        SearchEngineIndexManager manager = this.compass.getSearchEngineIndexManager();
        if (!manager.indexExists()) {
            manager.createIndex();
        }
        CompassIndexSession session = this.compass.openIndexSession();
        for (Product product : products) {
            session.save((Object)product);
        }
        session.commit();
        session.close();
    }

    @Override
    public SearchIntercept getInterceptForTerm(String term) {
        return this.searchInterceptDao.findInterceptByTerm(term);
    }

    @Override
    public List<SearchIntercept> getAllSearchIntercepts() {
        return this.searchInterceptDao.findAllIntercepts();
    }

    @Override
    public void createSearchIntercept(SearchIntercept intercept) {
        this.searchInterceptDao.createIntercept(intercept);
    }

    @Override
    public void deleteSearchIntercept(SearchIntercept intercept) {
        this.searchInterceptDao.deleteIntercept(intercept);
    }

    @Override
    public void updateSearchIntercept(SearchIntercept intercept) {
        this.searchInterceptDao.updateIntercept(intercept);
    }

    @Override
    public void createSearchSynonym(SearchSynonym synonym) {
        this.searchSynonymDao.createSynonym(synonym);
    }

    @Override
    public void deleteSearchSynonym(SearchSynonym synonym) {
        this.searchSynonymDao.deleteSynonym(synonym);
    }

    @Override
    public List<SearchSynonym> getAllSearchSynonyms() {
        return this.searchSynonymDao.getAllSynonyms();
    }

    @Override
    public void updateSearchSynonym(SearchSynonym synonym) {
        this.searchSynonymDao.updateSynonym(synonym);
    }

    public Compass getCompass() {
        return this.compass;
    }

    public void setCompass(Compass compass) {
        this.compass = compass;
    }

    public CatalogService getCatalogService() {
        return this.catalogService;
    }

    public void setCatalogService(CatalogService catalogService) {
        this.catalogService = catalogService;
    }

    public SearchInterceptDao getSearchInterceptDao() {
        return this.searchInterceptDao;
    }

    public void setSearchInterceptDao(SearchInterceptDao searchInterceptDao) {
        this.searchInterceptDao = searchInterceptDao;
    }

    public SearchSynonymDao getSearchSynonymDao() {
        return this.searchSynonymDao;
    }

    public void setSearchSynonymDao(SearchSynonymDao searchSynonymDao) {
        this.searchSynonymDao = searchSynonymDao;
    }
}

