/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.payment.domain.AmountItem;
import org.broadleafcommerce.core.payment.domain.AmountItemImpl;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.money.Money;
import org.broadleafcommerce.openadmin.client.dto.VisibilityEnum;
import org.broadleafcommerce.openadmin.client.presentation.SupportedFieldType;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.broadleafcommerce.presentation.AdminPresentationClass;
import org.broadleafcommerce.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.MapKey;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_PAYMENT")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="basePaymentInfo")
public class PaymentInfoImpl
implements PaymentInfo {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PaymentInfoId", strategy=GenerationType.TABLE)
    @TableGenerator(name="PaymentInfoId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="PaymentInfoImpl", allocationSize=50)
    @Column(name="PAYMENT_ID")
    protected Long id;
    @ManyToOne(targetEntity=OrderImpl.class, optional=false)
    @JoinColumn(name="ORDER_ID")
    @Index(name="ORDERPAYMENT_ORDER_INDEX", columnNames={"ORDER_ID"})
    @AdminPresentation(excluded=true, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Order order;
    @ManyToOne(targetEntity=AddressImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="ADDRESS_ID")
    @Index(name="ORDERPAYMENT_ADDRESS_INDEX", columnNames={"ADDRESS_ID"})
    @AdminPresentation(friendlyName="Payment Address", order=1, group="Address")
    protected Address address;
    @ManyToOne(targetEntity=PhoneImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="PHONE_ID")
    @Index(name="ORDERPAYMENT_PHONE_INDEX", columnNames={"PHONE_ID"})
    @AdminPresentation(friendlyName="Payment Phone", order=1, group="Phone")
    protected Phone phone;
    @Column(name="AMOUNT", precision=19, scale=5)
    @AdminPresentation(friendlyName="Payment Amount", order=3, group="Description", prominent=true, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal amount;
    @Column(name="REFERENCE_NUMBER")
    @Index(name="ORDERPAYMENT_REFERENCE_INDEX", columnNames={"REFERENCE_NUMBER"})
    @AdminPresentation(friendlyName="Payment Reference Number", order=1, group="Description", prominent=true)
    protected String referenceNumber;
    @Column(name="PAYMENT_TYPE", nullable=false)
    @Index(name="ORDERPAYMENT_TYPE_INDEX", columnNames={"PAYMENT_TYPE"})
    @AdminPresentation(friendlyName="Payment Type", order=2, group="Description", prominent=true, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.payment.service.type.PaymentInfoType")
    protected String type;
    @OneToMany(mappedBy="paymentInfo", targetEntity=AmountItemImpl.class, cascade={CascadeType.ALL})
    protected List<AmountItem> amountItems;
    @Column(name="CUSTOMER_IP_ADDRESS", nullable=true)
    @AdminPresentation(friendlyName="Payment IP Address", order=4, group="Description")
    protected String customerIpAddress;
    @CollectionOfElements
    @JoinTable(name="BLC_PAYINFO_ADDITIONAL_FIELDS", joinColumns={@JoinColumn(name="PAYMENT_ID")})
    @MapKey(columns={@Column(name="FIELD_NAME", length=150, nullable=false)})
    @Column(name="FIELD_VALUE")
    protected Map<String, String> additionalFields = new HashMap<String, String>();

    @Override
    public Money getAmount() {
        return this.amount == null ? null : new Money(this.amount);
    }

    @Override
    public void setAmount(Money amount) {
        this.amount = Money.toAmount((Money)amount);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(Address address) {
        this.address = address;
    }

    @Override
    public Phone getPhone() {
        return this.phone;
    }

    @Override
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public PaymentInfoType getType() {
        return PaymentInfoType.getInstance(this.type);
    }

    @Override
    public void setType(PaymentInfoType type) {
        this.type = type.getType();
    }

    @Override
    public List<AmountItem> getAmountItems() {
        return this.amountItems;
    }

    @Override
    public void setAmountItems(List<AmountItem> amountItems) {
        this.amountItems = amountItems;
    }

    @Override
    public String getCustomerIpAddress() {
        return this.customerIpAddress;
    }

    @Override
    public void setCustomerIpAddress(String customerIpAddress) {
        this.customerIpAddress = customerIpAddress;
    }

    @Override
    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    @Override
    public void setAdditionalFields(Map<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaymentInfoImpl other = (PaymentInfoImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.referenceNumber == null ? other.referenceNumber != null : !this.referenceNumber.equals(other.referenceNumber)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.referenceNumber == null ? 0 : this.referenceNumber.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }
}

