/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.core.payment.dao.SecurePaymentInfoDao;
import org.broadleafcommerce.core.payment.domain.BankAccountPaymentInfo;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.GiftCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.encryption.EncryptionModule;
import org.springframework.stereotype.Repository;

@Repository(value="blSecurePaymentInfoDao")
public class SecurePaymentInfoDaoImpl
implements SecurePaymentInfoDao {
    @PersistenceContext(unitName="blSecurePU")
    protected EntityManager em;
    @Resource(name="blEncryptionModule")
    protected EncryptionModule encryptionModule;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Referenced save(Referenced securePaymentInfo) {
        return (Referenced)this.em.merge((Object)securePaymentInfo);
    }

    @Override
    public BankAccountPaymentInfo createBankAccountPaymentInfo() {
        BankAccountPaymentInfo response = (BankAccountPaymentInfo)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.payment.domain.BankAccountPaymentInfo");
        response.setEncryptionModule(this.encryptionModule);
        return response;
    }

    @Override
    public GiftCardPaymentInfo createGiftCardPaymentInfo() {
        GiftCardPaymentInfo response = (GiftCardPaymentInfo)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.payment.domain.GiftCardPaymentInfo");
        response.setEncryptionModule(this.encryptionModule);
        return response;
    }

    @Override
    public CreditCardPaymentInfo createCreditCardPaymentInfo() {
        CreditCardPaymentInfo response = (CreditCardPaymentInfo)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo");
        response.setEncryptionModule(this.encryptionModule);
        return response;
    }

    @Override
    public BankAccountPaymentInfo findBankAccountInfo(String referenceNumber) {
        BankAccountPaymentInfo response;
        Query query = this.em.createNamedQuery("BC_READ_BANK_ACCOUNT_BY_REFERENCE_NUMBER");
        query.setParameter("referenceNumber", (Object)referenceNumber);
        List infos = query.getResultList();
        BankAccountPaymentInfo bankAccountPaymentInfo = response = infos == null || infos.size() == 0 ? null : (BankAccountPaymentInfo)infos.get(0);
        if (response != null) {
            response.setEncryptionModule(this.encryptionModule);
        }
        return response;
    }

    @Override
    public CreditCardPaymentInfo findCreditCardInfo(String referenceNumber) {
        CreditCardPaymentInfo response;
        Query query = this.em.createNamedQuery("BC_READ_CREDIT_CARD_BY_REFERENCE_NUMBER");
        query.setParameter("referenceNumber", (Object)referenceNumber);
        List infos = query.getResultList();
        CreditCardPaymentInfo creditCardPaymentInfo = response = infos == null || infos.size() == 0 ? null : (CreditCardPaymentInfo)infos.get(0);
        if (response != null) {
            response.setEncryptionModule(this.encryptionModule);
        }
        return response;
    }

    @Override
    public GiftCardPaymentInfo findGiftCardInfo(String referenceNumber) {
        GiftCardPaymentInfo response;
        Query query = this.em.createNamedQuery("BC_READ_GIFT_CARD_BY_REFERENCE_NUMBER");
        query.setParameter("referenceNumber", (Object)referenceNumber);
        List infos = query.getResultList();
        GiftCardPaymentInfo giftCardPaymentInfo = response = infos == null || infos.size() == 0 ? null : (GiftCardPaymentInfo)infos.get(0);
        if (response != null) {
            response.setEncryptionModule(this.encryptionModule);
        }
        return response;
    }

    @Override
    public void delete(Referenced securePaymentInfo) {
        if (!this.em.contains((Object)securePaymentInfo)) {
            securePaymentInfo = (Referenced)this.em.find(securePaymentInfo.getClass(), (Object)securePaymentInfo.getId());
        }
        this.em.remove((Object)securePaymentInfo);
    }
}

