/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadleafcommerce.cms.structure.domain.StructuredContent;
import org.broadleafcommerce.cms.structure.domain.StructuredContentItemCriteria;
import org.broadleafcommerce.cms.structure.service.AbstractStructuredContentRuleProcessor;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.profile.core.domain.Customer;

public class StructuredContentCartRuleProcessor
extends AbstractStructuredContentRuleProcessor {
    private OrderDao orderDao;

    public boolean checkForMatch(StructuredContent sc, Map<String, Object> valueMap) {
        Set itemCriteriaSet;
        if (sc != null && sc.getStructuredContentMatchRules() != null && (itemCriteriaSet = sc.getQualifyingItemCriteria()) != null && itemCriteriaSet.size() > 0) {
            Order order = this.lookupOrderForCustomer((Customer)valueMap.get("customer"));
            if (order == null || order.getOrderItems() == null || order.getOrderItems().size() < 1) {
                return false;
            }
            for (StructuredContentItemCriteria itemCriteria : itemCriteriaSet) {
                if (this.checkItemCriteria(itemCriteria, order.getOrderItems())) continue;
                return false;
            }
        }
        return true;
    }

    private Order lookupOrderForCustomer(Customer c) {
        Order o = null;
        if (c != null) {
            o = this.orderDao.readCartForCustomer(c);
        }
        return o;
    }

    private boolean checkItemCriteria(StructuredContentItemCriteria itemCriteria, List<OrderItem> orderItems) {
        HashMap<String, OrderItem> vars = new HashMap<String, OrderItem>();
        int foundCount = 0;
        Iterator<OrderItem> items = orderItems.iterator();
        while (foundCount < itemCriteria.getQuantity() && items.hasNext()) {
            OrderItem currentItem = items.next();
            vars.put("discreteOrderItem", currentItem);
            boolean match = this.executeExpression(itemCriteria.getOrderItemMatchRule(), vars);
            if (!match) continue;
            foundCount += currentItem.getQuantity();
        }
        return foundCount >= itemCriteria.getQuantity();
    }

    public void setOrderDao(OrderDao orderDao) {
        this.orderDao = orderDao;
    }

    public OrderDao getOrderDao() {
        return this.orderDao;
    }
}

