/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.FulfillmentGroupOfferPotential;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.processor.FulfillmentGroupOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.broadleafcommerce.money.Money;
import org.springframework.stereotype.Service;

@Service(value="blFulfillmentGroupOfferProcessor")
public class FulfillmentGroupOfferProcessorImpl
extends OrderOfferProcessorImpl
implements FulfillmentGroupOfferProcessor {
    @Override
    public void filterFulfillmentGroupLevelOffer(PromotableOrder order, List<PromotableCandidateFulfillmentGroupOffer> qualifiedFGOffers, Offer offer) {
        for (PromotableFulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            CandidatePromotionItems candidates;
            boolean fgLevelQualification = false;
            if (this.couldOfferApplyToOrder(offer, order, fulfillmentGroup)) {
                fgLevelQualification = true;
            } else {
                for (PromotableOrderItem discreteOrderItem : order.getDiscountableDiscreteOrderItems()) {
                    if (!this.couldOfferApplyToOrder(offer, order, discreteOrderItem, fulfillmentGroup)) continue;
                    fgLevelQualification = true;
                    break;
                }
            }
            if (fgLevelQualification) {
                fgLevelQualification = false;
                if (this.couldOfferApplyToFulfillmentGroup(offer, fulfillmentGroup)) {
                    fgLevelQualification = true;
                }
            }
            if (!fgLevelQualification || !(candidates = this.couldOfferApplyToOrderItems(offer, fulfillmentGroup.getDiscountableDiscreteOrderItems())).isMatchedQualifier()) continue;
            PromotableCandidateFulfillmentGroupOffer candidateOffer = this.createCandidateFulfillmentGroupOffer(offer, qualifiedFGOffers, fulfillmentGroup);
            candidateOffer.getCandidateQualifiersMap().putAll(candidates.getCandidateQualifiersMap());
        }
    }

    @Override
    public void calculateFulfillmentGroupTotal(PromotableOrder order) {
        Money totalShipping = new Money(0.0);
        for (PromotableFulfillmentGroup fulfillmentGroupMember : order.getFulfillmentGroups()) {
            PromotableFulfillmentGroup fulfillmentGroup = fulfillmentGroupMember;
            if (fulfillmentGroup.getAdjustmentPrice() != null) {
                fulfillmentGroup.setShippingPrice(fulfillmentGroup.getAdjustmentPrice());
            } else if (fulfillmentGroup.getSaleShippingPrice() != null) {
                fulfillmentGroup.setShippingPrice(fulfillmentGroup.getSaleShippingPrice());
            } else {
                fulfillmentGroup.setShippingPrice(fulfillmentGroup.getRetailShippingPrice());
            }
            totalShipping = totalShipping.add(fulfillmentGroup.getShippingPrice());
        }
        order.setTotalShipping(totalShipping);
    }

    protected boolean couldOfferApplyToFulfillmentGroup(Offer offer, PromotableFulfillmentGroup fulfillmentGroup) {
        boolean appliesToItem = false;
        OfferRule rule = offer.getOfferMatchRules().get(OfferRuleType.FULFILLMENT_GROUP.getType());
        if (rule != null && rule.getMatchRule() != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("fulfillmentGroup", fulfillmentGroup.getDelegate());
            Boolean expressionOutcome = this.executeExpression(rule.getMatchRule(), vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToItem = true;
            }
        } else {
            appliesToItem = true;
        }
        return appliesToItem;
    }

    protected PromotableCandidateFulfillmentGroupOffer createCandidateFulfillmentGroupOffer(Offer offer, List<PromotableCandidateFulfillmentGroupOffer> qualifiedFGOffers, PromotableFulfillmentGroup fulfillmentGroup) {
        CandidateFulfillmentGroupOffer candidateOffer = this.offerDao.createCandidateFulfillmentGroupOffer();
        candidateOffer.setFulfillmentGroup(fulfillmentGroup.getDelegate());
        candidateOffer.setOffer(offer);
        PromotableCandidateFulfillmentGroupOffer promotableCandidateFulfillmentGroupOffer = this.promotableItemFactory.createPromotableCandidateFulfillmentGroupOffer(candidateOffer, fulfillmentGroup);
        fulfillmentGroup.addCandidateFulfillmentGroupOffer(promotableCandidateFulfillmentGroupOffer);
        qualifiedFGOffers.add(promotableCandidateFulfillmentGroupOffer);
        return promotableCandidateFulfillmentGroupOffer;
    }

    @Override
    public boolean applyAllFulfillmentGroupOffers(List<PromotableCandidateFulfillmentGroupOffer> qualifiedFGOffers, PromotableOrder order) {
        HashMap offerMap = new HashMap();
        for (PromotableCandidateFulfillmentGroupOffer candidate : qualifiedFGOffers) {
            FulfillmentGroupOfferPotential potential = new FulfillmentGroupOfferPotential();
            potential.setOffer(candidate.getOffer());
            if (offerMap.get(potential) == null) {
                offerMap.put(potential, new ArrayList());
            }
            ((List)offerMap.get(potential)).add(candidate);
        }
        List<FulfillmentGroupOfferPotential> potentials = new ArrayList<FulfillmentGroupOfferPotential>();
        for (FulfillmentGroupOfferPotential potential : offerMap.keySet()) {
            List fgOffers = (List)offerMap.get(potential);
            Collections.sort(fgOffers, new ReverseComparator((Comparator)new BeanComparator("discountedAmount", (Comparator)new NullComparator())));
            Collections.sort(fgOffers, new BeanComparator("priority", (Comparator)new NullComparator()));
            if (potential.getOffer().getMaxUses() > 0 && fgOffers.size() > potential.getOffer().getMaxUses()) {
                for (int j = potential.getOffer().getMaxUses(); j < fgOffers.size(); ++j) {
                    fgOffers.remove(j);
                }
            }
            for (PromotableCandidateFulfillmentGroupOffer candidate : fgOffers) {
                potential.setTotalSavings(potential.getTotalSavings().add(candidate.getFulfillmentGroup().getPriceBeforeAdjustments(candidate.getOffer().getApplyDiscountToSalePrice()).subtract(candidate.getDiscountedPrice())));
                potential.setPriority(candidate.getOffer().getPriority());
            }
            potentials.add(potential);
        }
        Collections.sort(potentials, new BeanComparator("totalSavings", Collections.reverseOrder()));
        Collections.sort(potentials, new BeanComparator("priority"));
        potentials = this.removeTrailingNotCombinableFulfillmentGroupOffers(potentials);
        boolean fgOfferApplied = false;
        for (FulfillmentGroupOfferPotential potential : potentials) {
            List candidates;
            Offer offer = potential.getOffer();
            if (offer.getTreatAsNewFormat() == null || !offer.getTreatAsNewFormat().booleanValue()) {
                if (!offer.isStackable() && fgOfferApplied) continue;
                boolean alreadyContainsNotCombinableOfferAtAnyLevel = order.isNotCombinableOfferAppliedAtAnyLevel();
                candidates = (List)offerMap.get(potential);
                for (PromotableCandidateFulfillmentGroupOffer candidate : candidates) {
                    this.applyFulfillmentGroupOffer(candidate);
                    fgOfferApplied = true;
                }
                if (offer.isCombinableWithOtherOffers() && !alreadyContainsNotCombinableOfferAtAnyLevel || !(fgOfferApplied = this.compareAndAdjustFulfillmentGroupOffers(order, fgOfferApplied))) continue;
                break;
            }
            if (order.containsNotStackableFulfillmentGroupOffer() && fgOfferApplied) continue;
            boolean alreadyContainsTotalitarianOffer = order.isTotalitarianOfferApplied();
            candidates = (List)offerMap.get(potential);
            for (PromotableCandidateFulfillmentGroupOffer candidate : candidates) {
                this.applyFulfillmentGroupOffer(candidate);
                fgOfferApplied = true;
            }
            if (!(offer.isTotalitarianOffer() != null && offer.isTotalitarianOffer() != false || alreadyContainsTotalitarianOffer ? (fgOfferApplied = this.compareAndAdjustFulfillmentGroupOffers(order, fgOfferApplied)) : !offer.isCombinableWithOtherOffers())) continue;
            break;
        }
        return fgOfferApplied;
    }

    protected boolean compareAndAdjustFulfillmentGroupOffers(PromotableOrder order, boolean fgOfferApplied) {
        Money regularOrderDiscountShippingTotal = new Money(0.0);
        regularOrderDiscountShippingTotal = regularOrderDiscountShippingTotal.add(order.calculateOrderItemsPriceWithoutAdjustments());
        for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
            regularOrderDiscountShippingTotal = regularOrderDiscountShippingTotal.add(fg.getAdjustmentPrice());
        }
        Money discountOrderRegularShippingTotal = new Money(0.0);
        discountOrderRegularShippingTotal = discountOrderRegularShippingTotal.add(order.getSubTotal());
        for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
            discountOrderRegularShippingTotal = discountOrderRegularShippingTotal.add(fg.getPriceBeforeAdjustments(true));
        }
        if (discountOrderRegularShippingTotal.lessThan(regularOrderDiscountShippingTotal)) {
            order.removeAllFulfillmentAdjustments();
            fgOfferApplied = false;
        } else {
            order.removeAllOrderAdjustments();
            order.removeAllItemAdjustments();
            this.gatherCart(order);
            this.initializeSplitItems(order);
        }
        return fgOfferApplied;
    }

    protected void applyFulfillmentGroupOffer(PromotableCandidateFulfillmentGroupOffer fulfillmentGroupOffer) {
        FulfillmentGroupAdjustment fulfillmentGroupAdjustment = this.offerDao.createFulfillmentGroupAdjustment();
        fulfillmentGroupAdjustment.init(fulfillmentGroupOffer.getFulfillmentGroup().getDelegate(), fulfillmentGroupOffer.getOffer(), fulfillmentGroupOffer.getOffer().getName());
        PromotableFulfillmentGroupAdjustment promotableFulfillmentGroupAdjustment = this.promotableItemFactory.createPromotableFulfillmentGroupAdjustment(fulfillmentGroupAdjustment, fulfillmentGroupOffer.getFulfillmentGroup());
        fulfillmentGroupOffer.getFulfillmentGroup().addFulfillmentGroupAdjustment(promotableFulfillmentGroupAdjustment);
    }

    @Override
    public List<FulfillmentGroupOfferPotential> removeTrailingNotCombinableFulfillmentGroupOffers(List<FulfillmentGroupOfferPotential> candidateOffers) {
        ArrayList<FulfillmentGroupOfferPotential> remainingCandidateOffers = new ArrayList<FulfillmentGroupOfferPotential>();
        int offerCount = 0;
        for (FulfillmentGroupOfferPotential candidateOffer : candidateOffers) {
            if (offerCount == 0) {
                remainingCandidateOffers.add(candidateOffer);
            } else {
                boolean treatAsNewFormat = false;
                if (candidateOffer.getOffer().getTreatAsNewFormat() != null && candidateOffer.getOffer().getTreatAsNewFormat().booleanValue()) {
                    treatAsNewFormat = true;
                }
                if (!treatAsNewFormat && candidateOffer.getOffer().isCombinableWithOtherOffers() || treatAsNewFormat && (candidateOffer.getOffer().isTotalitarianOffer() == null || !candidateOffer.getOffer().isTotalitarianOffer().booleanValue())) {
                    remainingCandidateOffers.add(candidateOffer);
                }
            }
            ++offerCount;
        }
        return remainingCandidateOffers;
    }
}

