/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.money.Money;

public class PromotableCandidateItemOfferImpl
implements PromotableCandidateItemOffer {
    private static final long serialVersionUID = 1L;
    protected Money potentialSavings;
    protected HashMap<OfferItemCriteria, List<PromotableOrderItem>> candidateQualifiersMap = new HashMap();
    protected List<PromotableOrderItem> candidateTargets = new ArrayList<PromotableOrderItem>();
    protected CandidateItemOffer delegate;
    protected PromotableOrderItem orderItem;
    protected int uses = 0;

    public PromotableCandidateItemOfferImpl(CandidateItemOffer candidateItemOffer) {
        this.delegate = candidateItemOffer;
    }

    @Override
    public HashMap<OfferItemCriteria, List<PromotableOrderItem>> getCandidateQualifiersMap() {
        return this.candidateQualifiersMap;
    }

    @Override
    public void setCandidateQualifiersMap(HashMap<OfferItemCriteria, List<PromotableOrderItem>> candidateItemsMap) {
        this.candidateQualifiersMap = candidateItemsMap;
    }

    @Override
    public List<PromotableOrderItem> getCandidateTargets() {
        return this.candidateTargets;
    }

    @Override
    public void setCandidateTargets(List<PromotableOrderItem> candidateTargets) {
        this.candidateTargets = candidateTargets;
    }

    @Override
    public Money calculateSavingsForOrderItem(PromotableOrderItem orderItem, int qtyToReceiveSavings) {
        Money savings = new Money(0);
        Money salesPrice = orderItem.getPriceBeforeAdjustments(this.getOffer().getApplyDiscountToSalePrice());
        if (this.getOffer().getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
            savings = savings.add(new Money(this.getOffer().getValue()).multiply(qtyToReceiveSavings));
        } else if (this.getOffer().getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
            BigDecimal savingsPercent = this.getOffer().getValue().divide(new BigDecimal(100));
            savings = savings.add(salesPrice.multiply(savingsPercent).multiply(qtyToReceiveSavings));
        } else {
            savings = savings.add(salesPrice.multiply(qtyToReceiveSavings).subtract(new Money(this.getOffer().getValue()).multiply(qtyToReceiveSavings)));
        }
        return savings;
    }

    @Override
    public Money getPotentialSavings() {
        if (this.potentialSavings == null) {
            this.potentialSavings = this.calculatePotentialSavings();
        }
        return this.potentialSavings;
    }

    @Override
    public Money calculatePotentialSavings() {
        Money savings = new Money(0);
        int maxUses = this.calculateMaximumNumberOfUses();
        int appliedCount = 0;
        for (PromotableOrderItem chgItem : this.candidateTargets) {
            int qtyToReceiveSavings = Math.min(chgItem.getQuantity(), maxUses);
            savings = this.calculateSavingsForOrderItem(chgItem, qtyToReceiveSavings);
            if ((appliedCount += qtyToReceiveSavings) < maxUses) continue;
            return savings;
        }
        return savings;
    }

    @Override
    public int calculateMaximumNumberOfUses() {
        int maxMatchesFound = 9999;
        int numberOfUsesForThisItemCriteria = this.calculateMaxUsesForItemCriteria(this.delegate.getOffer().getTargetItemCriteria(), this.getOffer());
        maxMatchesFound = Math.min(maxMatchesFound, numberOfUsesForThisItemCriteria);
        int offerMaxUses = this.getOffer().getMaxUses() == 0 ? maxMatchesFound : this.getOffer().getMaxUses();
        return Math.min(maxMatchesFound, offerMaxUses);
    }

    @Override
    public int calculateMaxUsesForItemCriteria(OfferItemCriteria itemCriteria, Offer promotion) {
        int numberOfTargets = 0;
        int numberOfUsesForThisItemCriteria = 9999;
        if (this.candidateTargets != null && itemCriteria != null) {
            for (PromotableOrderItem potentialTarget : this.candidateTargets) {
                numberOfTargets += potentialTarget.getQuantityAvailableToBeUsedAsTarget(promotion);
            }
            numberOfUsesForThisItemCriteria = numberOfTargets / itemCriteria.getQuantity();
        }
        return numberOfUsesForThisItemCriteria;
    }

    @Override
    public CandidateItemOffer getDelegate() {
        return this.delegate;
    }

    @Override
    public void reset() {
        this.delegate = null;
    }

    @Override
    public void setOrderItem(PromotableOrderItem orderItem) {
        if (orderItem != null) {
            this.orderItem = orderItem;
            this.delegate.setOrderItem(this.orderItem.getDelegate());
        }
    }

    @Override
    public PromotableCandidateItemOffer clone() {
        PromotableCandidateItemOfferImpl copy = new PromotableCandidateItemOfferImpl(this.delegate.clone());
        copy.orderItem = this.orderItem;
        return copy;
    }

    @Override
    public int getPriority() {
        return this.delegate.getPriority();
    }

    @Override
    public Offer getOffer() {
        return this.delegate.getOffer();
    }

    @Override
    public void setOffer(Offer offer) {
        this.delegate.setOffer(offer);
    }

    @Override
    public PromotableOrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public int getUses() {
        return this.uses;
    }

    @Override
    public void addUse() {
        ++this.uses;
    }
}

