/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.money.Money;

public class PromotableCandidateFulfillmentGroupOfferImpl
implements PromotableCandidateFulfillmentGroupOffer {
    private static final long serialVersionUID = 1L;
    protected HashMap<OfferItemCriteria, List<PromotableOrderItem>> candidateQualifiersMap = new HashMap();
    protected CandidateFulfillmentGroupOffer delegate;
    protected PromotableFulfillmentGroup promotableFulfillmentGroup;
    protected Money discountedAmount;

    public PromotableCandidateFulfillmentGroupOfferImpl(CandidateFulfillmentGroupOffer candidateFulfillmentGroupOffer, PromotableFulfillmentGroup promotableFulfillmentGroup) {
        this.delegate = candidateFulfillmentGroupOffer;
        this.promotableFulfillmentGroup = promotableFulfillmentGroup;
    }

    @Override
    public HashMap<OfferItemCriteria, List<PromotableOrderItem>> getCandidateQualifiersMap() {
        return this.candidateQualifiersMap;
    }

    @Override
    public void setCandidateQualifiersMap(HashMap<OfferItemCriteria, List<PromotableOrderItem>> candidateItemsMap) {
        this.candidateQualifiersMap = candidateItemsMap;
    }

    @Override
    public void computeDiscountedPriceAndAmount() {
        if (this.delegate.getOffer() != null && this.delegate.getFulfillmentGroup() != null && this.delegate.getFulfillmentGroup().getRetailShippingPrice() != null) {
            Money priceToUse = this.delegate.getFulfillmentGroup().getRetailShippingPrice();
            this.discountedAmount = new Money(0);
            if (this.delegate.getOffer().getApplyDiscountToSalePrice() && this.delegate.getFulfillmentGroup().getSaleShippingPrice() != null) {
                priceToUse = this.delegate.getFulfillmentGroup().getSaleShippingPrice();
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                this.discountedAmount = new Money(this.delegate.getOffer().getValue());
            } else if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                this.discountedAmount = priceToUse.subtract(new Money(this.delegate.getOffer().getValue()));
            } else if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                this.discountedAmount = priceToUse.multiply(this.delegate.getOffer().getValue().divide(new BigDecimal("100")));
            }
            if (this.discountedAmount.greaterThan(priceToUse)) {
                this.discountedAmount = priceToUse;
            }
            priceToUse = priceToUse.subtract(this.discountedAmount);
            this.delegate.setDiscountedPrice(priceToUse);
        }
    }

    @Override
    public void reset() {
        this.delegate = null;
    }

    @Override
    public CandidateFulfillmentGroupOffer getDelegate() {
        return this.delegate;
    }

    @Override
    public Money getDiscountedPrice() {
        if (this.delegate.getDiscountedPrice() == null) {
            this.computeDiscountedPriceAndAmount();
        }
        return this.delegate.getDiscountedPrice();
    }

    @Override
    public Money getDiscountedAmount() {
        if (this.delegate.getDiscountedPrice() == null) {
            this.computeDiscountedPriceAndAmount();
        }
        return this.discountedAmount;
    }

    @Override
    public Offer getOffer() {
        return this.delegate.getOffer();
    }

    @Override
    public PromotableFulfillmentGroup getFulfillmentGroup() {
        return this.promotableFulfillmentGroup;
    }

    public int getPriority() {
        return this.delegate.getPriority();
    }
}

