/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service.workflow;

import java.util.Map;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.PaymentContextImpl;
import org.broadleafcommerce.core.payment.service.PaymentService;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.workflow.CombinedPaymentContextSeed;
import org.broadleafcommerce.core.payment.service.workflow.PaymentActionType;
import org.broadleafcommerce.core.payment.service.workflow.WorkflowPaymentContext;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.money.Money;

public class PaymentActivity
extends BaseActivity {
    protected PaymentService paymentService;
    protected String userName;

    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        CombinedPaymentContextSeed seed = ((WorkflowPaymentContext)context).getSeedData();
        Map<PaymentInfo, Referenced> infos = seed.getInfos();
        Money orderTotal = seed.getOrderTotal();
        Money remainingTotal = seed.getOrderTotal();
        for (PaymentInfo info : infos.keySet()) {
            PaymentResponseItem paymentResponseItem;
            if (!this.paymentService.isValidCandidate(info.getType()).booleanValue()) continue;
            PaymentContextImpl paymentContext = new PaymentContextImpl(orderTotal, remainingTotal, info, infos.get(info), this.userName);
            if (seed.getActionType().equals(PaymentActionType.AUTHORIZE)) {
                paymentResponseItem = this.paymentService.authorize(paymentContext);
            } else if (seed.getActionType().equals(PaymentActionType.AUTHORIZEANDDEBIT)) {
                paymentResponseItem = this.paymentService.authorizeAndDebit(paymentContext);
            } else if (seed.getActionType().equals(PaymentActionType.BALANCE)) {
                paymentResponseItem = this.paymentService.balance(paymentContext);
            } else if (seed.getActionType().equals(PaymentActionType.CREDIT)) {
                paymentResponseItem = this.paymentService.credit(paymentContext);
            } else if (seed.getActionType().equals(PaymentActionType.DEBIT)) {
                paymentResponseItem = this.paymentService.debit(paymentContext);
            } else if (seed.getActionType().equals(PaymentActionType.VOID)) {
                paymentResponseItem = this.paymentService.voidPayment(paymentContext);
            } else if (seed.getActionType().equals(PaymentActionType.REVERSEAUTHORIZE)) {
                paymentResponseItem = this.paymentService.reverseAuthorize(paymentContext);
            } else {
                throw new PaymentException("Module (" + this.paymentService.getClass().getName() + ") does not support payment type of: " + seed.getActionType().toString());
            }
            if (paymentResponseItem == null) continue;
            if (paymentResponseItem.getAmountPaid() == null || paymentResponseItem.getTransactionTimestamp() == null || paymentResponseItem.getTransactionSuccess() == null) {
                throw new PaymentException("The PaymentResponseItem instance did not contain one or more of the following: amountPaid, transactionTimestamp or transactionSuccess");
            }
            seed.getPaymentResponse().addPaymentResponseItem(info, paymentResponseItem);
            remainingTotal = remainingTotal.subtract(paymentResponseItem.getAmountPaid());
        }
        return context;
    }

    public PaymentService getPaymentService() {
        return this.paymentService;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

