/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOfferImpl;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustmentImpl;
import org.broadleafcommerce.core.order.domain.BundleOrderItemImpl;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFeeImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.PersonalMessage;
import org.broadleafcommerce.core.order.domain.PersonalMessageImpl;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupStatusType;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupType;
import org.broadleafcommerce.money.Money;
import org.broadleafcommerce.openadmin.client.presentation.SupportedFieldType;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_GROUP")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class FulfillmentGroupImpl
implements FulfillmentGroup {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FulfillmentGroupId", strategy=GenerationType.TABLE)
    @TableGenerator(name="FulfillmentGroupId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="FulfillmentGroupImpl", allocationSize=50)
    @Column(name="FULFILLMENT_GROUP_ID")
    protected Long id;
    @ManyToOne(targetEntity=OrderImpl.class, optional=false)
    @JoinColumn(name="ORDER_ID")
    @Index(name="FG_ORDER_INDEX", columnNames={"ORDER_ID"})
    protected Order order;
    @Column(name="REFERENCE_NUMBER")
    @Index(name="FG_REFERENCE_INDEX", columnNames={"REFERENCE_NUMBER"})
    @AdminPresentation(friendlyName="FG Reference Number", order=1, group="Description", prominent=true)
    protected String referenceNumber;
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupItemImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<FulfillmentGroupItem> fulfillmentGroupItems = new ArrayList<FulfillmentGroupItem>();
    @ManyToOne(targetEntity=AddressImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="ADDRESS_ID")
    @Index(name="FG_ADDRESS_INDEX", columnNames={"ADDRESS_ID"})
    protected Address address;
    @ManyToOne(targetEntity=PhoneImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="PHONE_ID")
    @Index(name="FG_PHONE_INDEX", columnNames={"PHONE_ID"})
    protected Phone phone;
    @Column(name="METHOD")
    @Index(name="FG_METHOD_INDEX", columnNames={"METHOD"})
    @AdminPresentation(friendlyName="Shipping Method", order=2, group="Description", prominent=true)
    protected String method;
    @Column(name="SERVICE")
    @Index(name="FG_SERVICE_INDEX", columnNames={"SERVICE"})
    @AdminPresentation(friendlyName="Shipping Service", order=3, group="Description", prominent=true)
    protected String service;
    @Column(name="RETAIL_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="Retail Shipping Price", order=1, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal retailShippingPrice;
    @Column(name="SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="Sale Shipping Price", order=2, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal saleShippingPrice;
    @Column(name="PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="Shipping Price", order=3, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal shippingPrice;
    @Column(name="TYPE")
    @AdminPresentation(friendlyName="FG Type", order=4, group="Description", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.order.service.type.FulfillmentGroupType")
    protected String type = FulfillmentGroupType.SHIPPING.getType();
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=CandidateFulfillmentGroupOfferImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<CandidateFulfillmentGroupOffer> candidateOffers = new ArrayList<CandidateFulfillmentGroupOffer>();
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupAdjustmentImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<FulfillmentGroupAdjustment> fulfillmentGroupAdjustments = new ArrayList<FulfillmentGroupAdjustment>();
    @Column(name="CITY_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FG City Tax", order=4, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal cityTax;
    @Column(name="COUNTY_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FG County Tax", order=5, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal countyTax;
    @Column(name="STATE_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FG State Tax", order=6, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal stateTax;
    @Column(name="DISTRICT_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FG District Tax", order=7, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal districtTax;
    @Column(name="COUNTRY_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FG Country Tax", order=8, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal countryTax;
    @Column(name="TOTAL_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FG Total Tax", order=9, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalTax;
    @Column(name="DELIVERY_INSTRUCTION")
    @AdminPresentation(friendlyName="FG Delivery Instruction", order=4, group="Description")
    protected String deliveryInstruction;
    @Column(name="IS_PRIMARY")
    @Index(name="FG_PRIMARY_INDEX", columnNames={"IS_PRIMARY"})
    @AdminPresentation(friendlyName="Primary FG", order=5, group="Description")
    protected boolean primary = false;
    @ManyToOne(targetEntity=PersonalMessageImpl.class)
    @JoinColumn(name="PERSONAL_MESSAGE_ID")
    @Index(name="FG_MESSAGE_INDEX", columnNames={"PERSONAL_MESSAGE_ID"})
    protected PersonalMessage personalMessage;
    @Column(name="MERCHANDISE_TOTAL", precision=19, scale=5)
    @AdminPresentation(friendlyName="FG Merchandise Total", order=10, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal merchandiseTotal;
    @Column(name="TOTAL", precision=19, scale=5)
    @AdminPresentation(friendlyName="FG Total", order=11, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal total;
    @Column(name="STATUS")
    @Index(name="FG_STATUS_INDEX", columnNames={"STATUS"})
    @AdminPresentation(friendlyName="FG Status", order=6, group="Description")
    protected String status;
    @OneToMany(mappedBy="fulfillmentGroup", targetEntity=FulfillmentGroupFeeImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<FulfillmentGroupFee> fulfillmentGroupFees = new ArrayList<FulfillmentGroupFee>();
    @Column(name="SHIPPING_PRICE_TAXABLE")
    @AdminPresentation(friendlyName="Shipping Price Taxable", order=7, group="Pricing")
    protected Boolean isShippingPriceTaxable = Boolean.FALSE;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public List<FulfillmentGroupItem> getFulfillmentGroupItems() {
        return this.fulfillmentGroupItems;
    }

    @Override
    public List<DiscreteOrderItem> getDiscreteOrderItems() {
        ArrayList<DiscreteOrderItem> discreteOrderItems = new ArrayList<DiscreteOrderItem>();
        for (FulfillmentGroupItem fgItem : this.fulfillmentGroupItems) {
            OrderItem orderItem = fgItem.getOrderItem();
            if (orderItem instanceof BundleOrderItemImpl) {
                BundleOrderItemImpl bundleOrderItem = (BundleOrderItemImpl)orderItem;
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    discreteOrderItems.add(discreteOrderItem);
                }
                continue;
            }
            DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)orderItem;
            discreteOrderItems.add(discreteOrderItem);
        }
        return discreteOrderItems;
    }

    @Override
    public void setFulfillmentGroupItems(List<FulfillmentGroupItem> fulfillmentGroupItems) {
        this.fulfillmentGroupItems = fulfillmentGroupItems;
    }

    @Override
    public void addFulfillmentGroupItem(FulfillmentGroupItem fulfillmentGroupItem) {
        if (this.fulfillmentGroupItems == null) {
            this.fulfillmentGroupItems = new Vector<FulfillmentGroupItem>();
        }
        this.fulfillmentGroupItems.add(fulfillmentGroupItem);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(Address address) {
        this.address = address;
    }

    @Override
    public Phone getPhone() {
        return this.phone;
    }

    @Override
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String fulfillmentMethod) {
        this.method = fulfillmentMethod;
    }

    @Override
    public Money getRetailShippingPrice() {
        return this.retailShippingPrice == null ? null : new Money(this.retailShippingPrice);
    }

    @Override
    public void setRetailShippingPrice(Money retailShippingPrice) {
        this.retailShippingPrice = Money.toAmount((Money)retailShippingPrice);
    }

    @Override
    public FulfillmentGroupType getType() {
        return FulfillmentGroupType.getInstance(this.type);
    }

    @Override
    public void setType(FulfillmentGroupType type) {
        this.type = type.getType();
    }

    @Override
    public void addCandidateFulfillmentGroupOffer(CandidateFulfillmentGroupOffer candidateOffer) {
        this.candidateOffers.add(candidateOffer);
    }

    @Override
    public List<CandidateFulfillmentGroupOffer> getCandidateFulfillmentGroupOffers() {
        return this.candidateOffers;
    }

    @Override
    public void setCandidateFulfillmentGroupOffer(List<CandidateFulfillmentGroupOffer> candidateOffers) {
        this.candidateOffers = candidateOffers;
    }

    @Override
    public void removeAllCandidateOffers() {
        if (this.candidateOffers != null) {
            for (CandidateFulfillmentGroupOffer offer : this.candidateOffers) {
                offer.setFulfillmentGroup(null);
            }
            this.candidateOffers.clear();
        }
    }

    @Override
    public List<FulfillmentGroupAdjustment> getFulfillmentGroupAdjustments() {
        return this.fulfillmentGroupAdjustments;
    }

    @Override
    public Money getFulfillmentGroupAdjustmentsValue() {
        Money adjustmentsValue = new Money(0);
        for (FulfillmentGroupAdjustment adjustment : this.fulfillmentGroupAdjustments) {
            adjustmentsValue = adjustmentsValue.add(adjustment.getValue());
        }
        return adjustmentsValue;
    }

    @Override
    public void removeAllAdjustments() {
        if (this.fulfillmentGroupAdjustments != null) {
            for (FulfillmentGroupAdjustment adjustment : this.fulfillmentGroupAdjustments) {
                adjustment.setFulfillmentGroup(null);
            }
            this.fulfillmentGroupAdjustments.clear();
        }
    }

    @Override
    public void setFulfillmentGroupAdjustments(List<FulfillmentGroupAdjustment> fulfillmentGroupAdjustments) {
        this.fulfillmentGroupAdjustments = fulfillmentGroupAdjustments;
    }

    @Override
    public Money getSaleShippingPrice() {
        return this.saleShippingPrice == null ? null : new Money(this.saleShippingPrice);
    }

    @Override
    public void setSaleShippingPrice(Money saleShippingPrice) {
        this.saleShippingPrice = Money.toAmount((Money)saleShippingPrice);
    }

    @Override
    public Money getShippingPrice() {
        return this.shippingPrice == null ? null : new Money(this.shippingPrice);
    }

    @Override
    public void setShippingPrice(Money shippingPrice) {
        this.shippingPrice = Money.toAmount((Money)shippingPrice);
    }

    @Override
    public Money getCityTax() {
        return this.cityTax == null ? null : new Money(this.cityTax);
    }

    @Override
    public void setCityTax(Money cityTax) {
        this.cityTax = Money.toAmount((Money)cityTax);
    }

    @Override
    public Money getCountyTax() {
        return this.countyTax == null ? null : new Money(this.countyTax);
    }

    @Override
    public void setCountyTax(Money countyTax) {
        this.countyTax = Money.toAmount((Money)countyTax);
    }

    @Override
    public Money getStateTax() {
        return this.stateTax == null ? null : new Money(this.stateTax);
    }

    @Override
    public void setStateTax(Money stateTax) {
        this.stateTax = Money.toAmount((Money)stateTax);
    }

    @Override
    public Money getDistrictTax() {
        return this.districtTax == null ? null : new Money(this.districtTax);
    }

    @Override
    public void setDistrictTax(Money districtTax) {
        this.districtTax = Money.toAmount((Money)districtTax);
    }

    @Override
    public Money getCountryTax() {
        return this.countryTax == null ? null : new Money(this.countryTax);
    }

    @Override
    public void setCountryTax(Money countryTax) {
        this.countryTax = Money.toAmount((Money)countryTax);
    }

    @Override
    public Money getTotalTax() {
        return this.totalTax == null ? null : new Money(this.totalTax);
    }

    @Override
    public void setTotalTax(Money totalTax) {
        this.totalTax = Money.toAmount((Money)totalTax);
    }

    @Override
    public String getDeliveryInstruction() {
        return this.deliveryInstruction;
    }

    @Override
    public void setDeliveryInstruction(String deliveryInstruction) {
        this.deliveryInstruction = deliveryInstruction;
    }

    @Override
    public PersonalMessage getPersonalMessage() {
        return this.personalMessage;
    }

    @Override
    public void setPersonalMessage(PersonalMessage personalMessage) {
        this.personalMessage = personalMessage;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    @Override
    public Money getMerchandiseTotal() {
        return this.merchandiseTotal == null ? null : new Money(this.merchandiseTotal);
    }

    @Override
    public void setMerchandiseTotal(Money merchandiseTotal) {
        this.merchandiseTotal = Money.toAmount((Money)merchandiseTotal);
    }

    @Override
    public Money getTotal() {
        return this.total == null ? null : new Money(this.total);
    }

    @Override
    public void setTotal(Money orderTotal) {
        this.total = Money.toAmount((Money)orderTotal);
    }

    @Override
    public FulfillmentGroupStatusType getStatus() {
        return FulfillmentGroupStatusType.getInstance(this.status);
    }

    public void setStatus(FulfillmentGroupStatusType status) {
        this.status = status.getType();
    }

    @Override
    public List<FulfillmentGroupFee> getFulfillmentGroupFees() {
        return this.fulfillmentGroupFees;
    }

    @Override
    public void setFulfillmentGroupFees(List<FulfillmentGroupFee> fulfillmentGroupFees) {
        this.fulfillmentGroupFees = fulfillmentGroupFees;
    }

    @Override
    public void addFulfillmentGroupFee(FulfillmentGroupFee fulfillmentGroupFee) {
        if (this.fulfillmentGroupFees == null) {
            this.fulfillmentGroupFees = new ArrayList<FulfillmentGroupFee>();
        }
        this.fulfillmentGroupFees.add(fulfillmentGroupFee);
    }

    @Override
    public void removeAllFulfillmentGroupFees() {
        if (this.fulfillmentGroupFees != null) {
            this.fulfillmentGroupFees.clear();
        }
    }

    @Override
    public Boolean isShippingPriceTaxable() {
        return this.isShippingPriceTaxable;
    }

    @Override
    public void setIsShippingPriceTaxable(Boolean isShippingPriceTaxable) {
        this.isShippingPriceTaxable = isShippingPriceTaxable;
    }

    @Override
    public String getService() {
        return this.service;
    }

    @Override
    public void setService(String service) {
        this.service = service;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.fulfillmentGroupItems == null ? 0 : ((Object)this.fulfillmentGroupItems).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentGroupImpl other = (FulfillmentGroupImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return !(this.fulfillmentGroupItems == null ? other.fulfillmentGroupItems != null : !((Object)this.fulfillmentGroupItems).equals(other.fulfillmentGroupItems));
    }
}

