/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.profile.util.BroadleafEnumerationType;

public class OfferType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, OfferType> TYPES = new HashMap<String, OfferType>();
    public static final OfferType ORDER = new OfferType("ORDER", "Order");
    public static final OfferType FULFILLMENT_GROUP = new OfferType("FULFILLMENT_GROUP", "Fulfillment Group");
    public static final OfferType ORDER_ITEM = new OfferType("ORDER_ITEM", "Order Item");
    private String type;
    private String friendlyType;

    public static OfferType getInstance(String type) {
        return TYPES.get(type);
    }

    public OfferType() {
    }

    public OfferType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OfferType other = (OfferType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

