/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="BLC_OFFER_ITEM_CRITERIA")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class OfferItemCriteriaImpl
implements OfferItemCriteria {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OfferItemCriteriaId")
    @GenericGenerator(name="OfferItemCriteriaId", strategy="org.broadleafcommerce.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="OfferItemCriteriaImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.OfferItemCriteriaImpl")})
    @Column(name="OFFER_ITEM_CRITERIA_ID")
    @AdminPresentation(friendlyName="Item Criteria Id", group="Description", hidden=true)
    protected Long id;
    @Column(name="QUANTITY", nullable=false)
    @AdminPresentation(friendlyName="Quantity", group="Description", hidden=true)
    protected Integer quantity;
    @Lob
    @Column(name="ORDER_ITEM_MATCH_RULE")
    @AdminPresentation(friendlyName="Order Item Match Rule", group="Description", hidden=true)
    protected String orderItemMatchRule;
    @ManyToOne(targetEntity=OfferImpl.class)
    @JoinTable(name="BLC_QUAL_CRIT_OFFER_XREF", joinColumns={@JoinColumn(name="OFFER_ITEM_CRITERIA_ID")}, inverseJoinColumns={@JoinColumn(name="OFFER_ID")})
    protected Offer offer;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(Integer receiveQuantity) {
        this.quantity = receiveQuantity;
    }

    @Override
    public String getOrderItemMatchRule() {
        return this.orderItemMatchRule;
    }

    @Override
    public void setOrderItemMatchRule(String orderItemMatchRule) {
        this.orderItemMatchRule = orderItemMatchRule;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.orderItemMatchRule == null ? 0 : this.orderItemMatchRule.hashCode());
        result = 31 * result + (this.quantity == null ? 0 : this.quantity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OfferItemCriteriaImpl other = (OfferItemCriteriaImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.orderItemMatchRule == null ? other.orderItemMatchRule != null : !this.orderItemMatchRule.equals(other.orderItemMatchRule)) {
            return false;
        }
        return !(this.quantity == null ? other.quantity != null : !this.quantity.equals(other.quantity));
    }
}

