/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import java.math.BigDecimal;
import java.sql.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferAudit;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.money.Money;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="BLC_OFFER_AUDIT")
@Inheritance(strategy=InheritanceType.JOINED)
public class OfferAuditImpl
implements OfferAudit {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OfferAuditId")
    @GenericGenerator(name="OfferAuditId", strategy="org.broadleafcommerce.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="OfferAuditImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.OfferAuditImpl")})
    @Column(name="OFFER_AUDIT_ID")
    protected Long id;
    @ManyToOne(targetEntity=OfferImpl.class)
    @JoinColumn(name="OFFER_ID")
    @Index(name="OFFERAUDIT_OFFER_INDEX", columnNames={"OFFER_ID"})
    protected Offer offer;
    @Column(name="OFFER_CODE_ID")
    @Index(name="OFFERAUDIT_OFFERCODE_INDEX", columnNames={"OFFER_CODE_ID"})
    protected Long offerCodeId;
    @Column(name="CUSTOMER_ID")
    @Index(name="OFFERAUDIT_CUSTOMER_INDEX", columnNames={"CUSTOMER_ID"})
    protected Long customerId;
    @Column(name="OFFER_TYPE")
    @Index(name="OFFERAUDIT_TYPE_INDEX", columnNames={"OFFER_TYPE"})
    protected String offerType;
    @Column(name="RELATED_ID")
    @Index(name="OFFERAUDIT_RELATED_INDEX", columnNames={"RELATED_ID"})
    protected Long relatedId;
    @Column(name="RELATED_RETAIL_PRICE", precision=19, scale=5)
    protected BigDecimal relatedRetailPrice;
    @Column(name="RELATED_SALE_PRICE", precision=19, scale=5)
    protected BigDecimal relatedSalePrice;
    @Column(name="RELATED_PRICE", precision=19, scale=5)
    protected BigDecimal relatedPrice;
    @Column(name="REDEEMED_DATE")
    protected Date redeemedDate;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    @Override
    public Long getOfferCodeId() {
        return this.offerCodeId;
    }

    @Override
    public void setOfferCodeId(Long offerCodeId) {
        this.offerCodeId = offerCodeId;
    }

    @Override
    public Long getCustomerId() {
        return this.customerId;
    }

    @Override
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public OfferDiscountType getOfferType() {
        return OfferDiscountType.getInstance(this.offerType);
    }

    public void setOfferType(OfferDiscountType offerType) {
        this.offerType = offerType.getType();
    }

    public Long getRelatedId() {
        return this.relatedId;
    }

    @Override
    public void setRelatedId(Long relatedId) {
        this.relatedId = relatedId;
    }

    @Override
    public Money getRelatedRetailPrice() {
        return this.relatedRetailPrice == null ? null : new Money(this.relatedRetailPrice);
    }

    @Override
    public void setRelatedRetailPrice(Money relatedRetailPrice) {
        this.relatedRetailPrice = Money.toAmount((Money)relatedRetailPrice);
    }

    @Override
    public Money getRelatedSalePrice() {
        return this.relatedSalePrice == null ? null : new Money(this.relatedSalePrice);
    }

    @Override
    public void setRelatedSalePrice(Money relatedSalePrice) {
        this.relatedSalePrice = Money.toAmount((Money)relatedSalePrice);
    }

    @Override
    public Money getRelatedPrice() {
        return this.relatedPrice == null ? null : new Money(this.relatedPrice);
    }

    @Override
    public void setRelatedPrice(Money relatedPrice) {
        this.relatedPrice = Money.toAmount((Money)relatedPrice);
    }

    @Override
    public Date getRedeemedDate() {
        return this.redeemedDate;
    }

    @Override
    public void setRedeemedDate(Date redeemedDate) {
        this.redeemedDate = redeemedDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customerId == null ? 0 : this.customerId.hashCode());
        result = 31 * result + (this.offer == null ? 0 : this.offer.hashCode());
        result = 31 * result + (this.offerCodeId == null ? 0 : this.offerCodeId.hashCode());
        result = 31 * result + (this.offerType == null ? 0 : this.offerType.hashCode());
        result = 31 * result + (this.redeemedDate == null ? 0 : this.redeemedDate.hashCode());
        result = 31 * result + (this.relatedId == null ? 0 : this.relatedId.hashCode());
        result = 31 * result + (this.relatedPrice == null ? 0 : this.relatedPrice.hashCode());
        result = 31 * result + (this.relatedRetailPrice == null ? 0 : this.relatedRetailPrice.hashCode());
        result = 31 * result + (this.relatedSalePrice == null ? 0 : this.relatedSalePrice.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OfferAuditImpl other = (OfferAuditImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.customerId == null ? other.customerId != null : !this.customerId.equals(other.customerId)) {
            return false;
        }
        if (this.offer == null ? other.offer != null : !this.offer.equals(other.offer)) {
            return false;
        }
        if (this.offerCodeId == null ? other.offerCodeId != null : !this.offerCodeId.equals(other.offerCodeId)) {
            return false;
        }
        if (this.offerType == null ? other.offerType != null : !this.offerType.equals(other.offerType)) {
            return false;
        }
        if (this.redeemedDate == null ? other.redeemedDate != null : !this.redeemedDate.equals(other.redeemedDate)) {
            return false;
        }
        if (this.relatedId == null ? other.relatedId != null : !this.relatedId.equals(other.relatedId)) {
            return false;
        }
        if (this.relatedPrice == null ? other.relatedPrice != null : !this.relatedPrice.equals(other.relatedPrice)) {
            return false;
        }
        if (this.relatedRetailPrice == null ? other.relatedRetailPrice != null : !this.relatedRetailPrice.equals(other.relatedRetailPrice)) {
            return false;
        }
        return !(this.relatedSalePrice == null ? other.relatedSalePrice != null : !this.relatedSalePrice.equals(other.relatedSalePrice));
    }
}

