/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.content.domain;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.content.domain.Content;
import org.hibernate.annotations.Index;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CONTENT")
public class ContentImpl
implements Content {
    private static final Log LOG = LogFactory.getLog(CategoryImpl.class);
    private static final long serialVersionUID = 1L;
    @Column(name="ACTIVE_END_DATE")
    protected Date activeEndDate;
    @Column(name="ACTIVE_START_DATE")
    protected Date activeStartDate;
    @Column(name="APPROVED_BY")
    protected String approvedBy;
    @Column(name="APPROVED_DATE")
    protected Date approvedDate;
    @Column(name="BROWSER_TITLE")
    protected String browserTitle;
    @Column(name="CONTENT_DATE")
    protected Date contentDate;
    @Column(name="CONTENT_TYPE")
    protected String contentType;
    @Column(name="DISPLAY_RULE")
    protected String displayRule;
    @Column(name="DEPLOYED")
    protected Boolean deployed;
    @Lob
    @Column(name="DESCRIPTION")
    protected String description;
    @Id
    @GeneratedValue(generator="ContentId", strategy=GenerationType.TABLE)
    @TableGenerator(name="ContentId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="ContentImpl", allocationSize=50)
    @Column(name="ID")
    protected Integer id;
    @Column(name="KEYWORDS")
    protected String keywords;
    @Column(name="LANGUAGE_CODE")
    protected String languageCode;
    @Column(name="LAST_MODIFIED_DATE")
    protected Date lastModifiedDate;
    @Column(name="LAST_MODIFIED_BY")
    protected String lastModifiedBy;
    @Column(name="META_DESCRIPTION")
    protected String metaDescription;
    @Column(name="NOTE")
    protected String note;
    @Column(name="ONLINE_STATE")
    protected Boolean online;
    @Column(name="PARENT_CONTENT_ID")
    protected Integer parentContentId;
    @Column(name="PRIORITY")
    protected Integer priority;
    @Column(name="REJECTED_BY")
    protected String rejectedBy;
    @Column(name="REJECTED_DATE")
    protected Date rejectedDate;
    @Column(name="RENDER_TEMPLATE")
    protected String renderTemplate;
    @Column(name="SANDBOX")
    @Index(name="CONTENT_INDEX", columnNames={"SANDBOX", "TITLE"})
    protected String sandbox;
    @Column(name="SUBMITTED_BY")
    protected String submittedBy;
    @Column(name="SUBMITTED_DATE")
    protected Date submittedDate;
    @Column(name="TITLE")
    protected String title;
    @Column(name="URL_TITLE")
    protected String urlTitle;

    public ContentImpl() {
    }

    public ContentImpl(Content cnt, String sandbox, boolean deployed) {
        this.activeEndDate = cnt.getActiveEndDate();
        this.activeStartDate = cnt.getActiveStartDate();
        this.approvedBy = cnt.getApprovedBy();
        this.approvedDate = cnt.getApprovedDate();
        this.browserTitle = cnt.getBrowserTitle();
        this.contentDate = cnt.getContentDate();
        this.contentType = cnt.getContentType();
        this.displayRule = cnt.getDisplayRule();
        this.description = cnt.getDescription();
        this.deployed = deployed;
        this.keywords = cnt.getKeywords();
        this.languageCode = cnt.getLanguageCode();
        this.lastModifiedBy = cnt.getLastModifiedBy();
        this.lastModifiedDate = cnt.getLastModifiedDate();
        this.metaDescription = cnt.getMetaDescription();
        this.note = cnt.getNote();
        this.parentContentId = cnt.getParentContentId();
        this.priority = cnt.getPriority();
        this.rejectedBy = cnt.getRejectedBy();
        this.rejectedDate = cnt.getRejectedDate();
        this.renderTemplate = cnt.getRenderTemplate();
        this.sandbox = sandbox;
        this.submittedBy = cnt.getSubmittedBy();
        this.submittedDate = cnt.getSubmittedDate();
        this.title = cnt.getTitle();
        this.urlTitle = cnt.getUrlTitle();
    }

    @Override
    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    @Override
    public Date getActiveStartDate() {
        return this.activeStartDate;
    }

    @Override
    public String getApprovedBy() {
        return this.approvedBy;
    }

    @Override
    public Date getApprovedDate() {
        return this.approvedDate;
    }

    @Override
    public String getBrowserTitle() {
        return this.browserTitle;
    }

    @Override
    public Date getContentDate() {
        return this.contentDate;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getDisplayRule() {
        return this.displayRule;
    }

    @Override
    public Boolean getDeployed() {
        return this.deployed;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getKeywords() {
        return this.keywords;
    }

    @Override
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Override
    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    @Override
    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    @Override
    public String getMetaDescription() {
        return this.metaDescription;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public Boolean getOnline() {
        return this.online;
    }

    @Override
    public Integer getParentContentId() {
        return this.parentContentId;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public String getRejectedBy() {
        return this.rejectedBy;
    }

    @Override
    public Date getRejectedDate() {
        return this.rejectedDate;
    }

    @Override
    public String getRenderTemplate() {
        return this.renderTemplate;
    }

    @Override
    public String getSandbox() {
        return this.sandbox;
    }

    @Override
    public String getSubmittedBy() {
        return this.submittedBy;
    }

    @Override
    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getUrlTitle() {
        return this.urlTitle;
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    @Override
    public void setApprovedBy(String approvedBy) {
        this.approvedBy = approvedBy;
    }

    @Override
    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    @Override
    public void setBrowserTitle(String browserTitle) {
        this.browserTitle = browserTitle;
    }

    @Override
    public void setContentDate(Date contentDate) {
        this.contentDate = contentDate;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setDisplayRule(String displayRule) {
        this.displayRule = displayRule;
    }

    @Override
    public void setDeployed(Boolean deployed) {
        this.deployed = deployed;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    @Override
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    @Override
    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    @Override
    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    @Override
    public void setMetaDescription(String metaDescription) {
        this.metaDescription = metaDescription;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public void setOnline(Boolean online) {
        this.online = online;
    }

    @Override
    public void setParentContentId(Integer parentContentId) {
        this.parentContentId = parentContentId;
    }

    @Override
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Override
    public void setRejectedBy(String rejectedBy) {
        this.rejectedBy = rejectedBy;
    }

    @Override
    public void setRejectedDate(Date rejectedDate) {
        this.rejectedDate = rejectedDate;
    }

    @Override
    public void setRenderTemplate(String renderTemplate) {
        this.renderTemplate = renderTemplate;
    }

    @Override
    public void setSandbox(String sandbox) {
        this.sandbox = sandbox;
    }

    @Override
    public void setSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
    }

    @Override
    public void setSubmittedDate(Date submittedDate) {
        this.submittedDate = submittedDate;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setUrlTitle(String urlTitle) {
        this.urlTitle = urlTitle;
    }
}

