/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.content.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.core.content.dao.ContentDao;
import org.broadleafcommerce.core.content.domain.Content;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.util.dao.BatchRetrieveDao;
import org.springframework.stereotype.Repository;

@Repository(value="blContentDao")
public class ContentDaoImpl
extends BatchRetrieveDao
implements ContentDao {
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    protected String queryCacheableKey = "org.hibernate.cacheable";

    @Override
    public void delete(Content content) {
        if (!this.em.contains((Object)content)) {
            content = this.readContentById(content.getId());
        }
        this.em.remove((Object)content);
    }

    @Override
    public void delete(List<Content> contentList) {
        for (Content content : contentList) {
            this.delete(content);
        }
    }

    public String getQueryCacheableKey() {
        return this.queryCacheableKey;
    }

    @Override
    public List<Content> readContentAwaitingApproval() {
        Query query = this.em.createNamedQuery("BC_READ_CONTENT_AWAITING_APPROVAL");
        return query.getResultList();
    }

    @Override
    public Content readContentById(Integer id) {
        return (Content)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.core.content.domain.Content"), (Object)id);
    }

    @Override
    public List<Content> readContentByIdsAndSandbox(List<Integer> ids, String sandbox) {
        Query query;
        if (sandbox == null) {
            query = this.em.createNamedQuery("BC_READ_CONTENT_BY_IDS_WHERE_SANDBOX_IS_NULL");
        } else {
            query = this.em.createNamedQuery("BC_READ_CONTENT_BY_IDS_AND_SANDBOX");
            query.setParameter("sandbox", (Object)sandbox);
        }
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return this.batchExecuteReadQuery(query, ids, "idList");
    }

    @Override
    public List<Content> readContentBySandbox(String sandbox) {
        Query query = null;
        query = sandbox != null && sandbox.endsWith("*") ? this.em.createNamedQuery("BC_READ_CONTENT_BY_LIKE_SANDBOX") : this.em.createNamedQuery("BC_READ_CONTENT_BY_SANDBOX");
        query.setParameter("sandbox", (Object)sandbox);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public List<Content> readContentBySandboxAndType(String sandbox, String contentType) {
        Query query = null;
        if (sandbox == null) {
            query = this.em.createNamedQuery("BC_READ_CONTENT_BY_NULL_SANDBOX_AND_CONTENT_TYPE");
        } else {
            query = this.em.createNamedQuery("BC_READ_CONTENT_BY_SANDBOX_AND_CONTENT_TYPE");
            query.setParameter("sandbox", (Object)sandbox);
        }
        query.setParameter("contentType", (Object)contentType);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public List<Content> readContentSpecified(String sandbox, String contentType, Date displayDate) {
        Query query = this.em.createNamedQuery("BC_READ_CONTENT_SPECIFIED");
        query.setParameter("sandbox", (Object)sandbox);
        query.setParameter("contentType", (Object)contentType);
        query.setParameter("displayDate", (Object)displayDate);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public Content saveContent(Content content) {
        return (Content)this.em.merge((Object)content);
    }

    @Override
    public List<Content> saveContent(List<Content> contentList) {
        for (Content content : contentList) {
            this.saveContent(content);
        }
        return contentList;
    }

    public void setQueryCacheableKey(String queryCacheableKey) {
        this.queryCacheableKey = queryCacheableKey;
    }

    @Override
    public List<Content> readStagedContent() {
        Query query = this.em.createNamedQuery("BC_READ_STAGED_CONTENT");
        return query.getResultList();
    }

    @Override
    public List<Content> readAllContent() {
        Query query = this.em.createNamedQuery("BC_READ_ALL_CONTENT");
        return query.getResultList();
    }
}

