/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.profile.util.BroadleafEnumerationType;

public class ProductType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, ProductType> TYPES = new HashMap<String, ProductType>();
    public static final ProductType PRODUCT = new ProductType("org.broadleafcommerce.core.catalog.domain.Product", "Normal Product");
    public static final ProductType PRODUCT_SKU = new ProductType("org.broadleafcommerce.core.catalog.domain.ProductSku", "One To One Product Sku");
    private String type;
    private String friendlyType;

    public static ProductType getInstance(String type) {
        return TYPES.get(type);
    }

    public ProductType() {
    }

    public ProductType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductType other = (ProductType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

