/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuAttribute;
import org.broadleafcommerce.core.catalog.domain.SkuAttributeImpl;
import org.broadleafcommerce.core.catalog.service.dynamic.DefaultDynamicSkuPricingInvocationHandler;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuPrices;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuPricingConsiderationContext;
import org.broadleafcommerce.core.media.domain.Media;
import org.broadleafcommerce.core.media.domain.MediaImpl;
import org.broadleafcommerce.money.Money;
import org.broadleafcommerce.openadmin.client.presentation.SupportedFieldType;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.broadleafcommerce.profile.util.DateUtil;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableId;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SKU")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@Searchable
public class SkuImpl
implements Sku {
    private static final Log LOG = LogFactory.getLog(SkuImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SkuId")
    @GenericGenerator(name="SkuId", strategy="org.broadleafcommerce.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="SkuImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.SkuImpl")})
    @Column(name="SKU_ID")
    @SearchableId
    @AdminPresentation(friendlyName="Sku ID", group="Primary Key", hidden=true)
    protected Long id;
    @Column(name="SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="Sku Sale Price", order=9, group="Price", prominent=true, fieldType=SupportedFieldType.MONEY, groupOrder=3)
    protected BigDecimal salePrice;
    @Column(name="RETAIL_PRICE", nullable=false, precision=19, scale=5)
    @AdminPresentation(friendlyName="Sku Retail Price", order=10, group="Price", prominent=true, fieldType=SupportedFieldType.MONEY, groupOrder=3)
    protected BigDecimal retailPrice;
    @Column(name="NAME", nullable=false)
    @SearchableProperty
    @Index(name="SKU_NAME_INDEX", columnNames={"NAME"})
    @AdminPresentation(friendlyName="Sku Name", order=1, group="Sku Description", prominent=true, columnWidth="25%", groupOrder=4)
    protected String name;
    @Column(name="DESCRIPTION")
    @AdminPresentation(friendlyName="Sku Description", order=2, group="Sku Description", largeEntry=true, groupOrder=4)
    protected String description;
    @Column(name="LONG_DESCRIPTION")
    @AdminPresentation(friendlyName="Sku Large Description", order=3, group="Sku Description", largeEntry=true, groupOrder=4)
    protected String longDescription;
    @Column(name="TAXABLE_FLAG")
    @Index(name="SKU_TAXABLE_INDEX", columnNames={"TAXABLE_FLAG"})
    @AdminPresentation(friendlyName="Sku Taxable", order=4, group="Sku Description", groupOrder=4)
    protected Character taxable;
    @Column(name="DISCOUNTABLE_FLAG")
    @Index(name="SKU_DISCOUNTABLE_INDEX", columnNames={"DISCOUNTABLE_FLAG"})
    @AdminPresentation(friendlyName="Sku Discountable", order=5, group="Sku Description", groupOrder=4)
    protected Character discountable;
    @Column(name="AVAILABLE_FLAG")
    @Index(name="SKU_AVAILABLE_INDEX", columnNames={"AVAILABLE_FLAG"})
    @AdminPresentation(friendlyName="Sku Available", order=6, group="Sku Description", groupOrder=4)
    protected Character available;
    @Column(name="ACTIVE_START_DATE")
    @AdminPresentation(friendlyName="Sku Start Date", order=7, group="Sku Description", groupOrder=4)
    protected Date activeStartDate;
    @Column(name="ACTIVE_END_DATE")
    @Index(name="SKU_ACTIVE_INDEX", columnNames={"ACTIVE_START_DATE", "ACTIVE_END_DATE"})
    @AdminPresentation(friendlyName="Sku End Date", order=8, group="Sku Description", groupOrder=4)
    protected Date activeEndDate;
    @Transient
    protected DynamicSkuPrices dynamicPrices = null;
    @CollectionOfElements
    @JoinTable(name="BLC_SKU_IMAGE", joinColumns={@JoinColumn(name="SKU_ID")})
    @MapKey(columns={@Column(name="NAME", length=5, nullable=false)})
    @Column(name="URL")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @Deprecated
    protected Map<String, String> skuImages = new HashMap<String, String>();
    @ManyToMany(targetEntity=MediaImpl.class)
    @JoinTable(name="BLC_SKU_MEDIA_MAP", inverseJoinColumns={@JoinColumn(name="MEDIA_ID", referencedColumnName="MEDIA_ID")})
    @MapKey(columns={@Column(name="MAP_KEY", nullable=false)})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    protected Map<String, Media> skuMedia = new HashMap<String, Media>();
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=ProductImpl.class)
    @JoinTable(name="BLC_PRODUCT_SKU_XREF", joinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID", nullable=true)}, inverseJoinColumns={@JoinColumn(name="PRODUCT_ID", referencedColumnName="PRODUCT_ID", nullable=true)})
    protected List<Product> allParentProducts = new ArrayList<Product>();
    @OneToMany(mappedBy="sku", targetEntity=SkuAttributeImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<SkuAttribute> skuAttributes = new ArrayList<SkuAttribute>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Money getSalePrice() {
        if (this.dynamicPrices != null) {
            return this.dynamicPrices.getSalePrice();
        }
        if (SkuPricingConsiderationContext.getSkuPricingConsiderationContext() != null && SkuPricingConsiderationContext.getSkuPricingConsiderationContext().size() > 0 && SkuPricingConsiderationContext.getSkuPricingService() != null) {
            DefaultDynamicSkuPricingInvocationHandler handler = new DefaultDynamicSkuPricingInvocationHandler(this);
            Sku proxy = (Sku)Proxy.newProxyInstance(this.getClass().getClassLoader(), this.getClass().getInterfaces(), (InvocationHandler)handler);
            this.dynamicPrices = SkuPricingConsiderationContext.getSkuPricingService().getSkuPrices(proxy, SkuPricingConsiderationContext.getSkuPricingConsiderationContext());
            handler.reset();
            return this.dynamicPrices.getSalePrice();
        }
        return this.salePrice == null ? null : new Money(this.salePrice);
    }

    @Override
    public void setSalePrice(Money salePrice) {
        this.salePrice = Money.toAmount((Money)salePrice);
    }

    @Override
    public Money getRetailPrice() {
        if (this.dynamicPrices != null) {
            return this.dynamicPrices.getRetailPrice();
        }
        if (SkuPricingConsiderationContext.getSkuPricingConsiderationContext() != null && SkuPricingConsiderationContext.getSkuPricingConsiderationContext().size() > 0 && SkuPricingConsiderationContext.getSkuPricingService() != null) {
            DefaultDynamicSkuPricingInvocationHandler handler = new DefaultDynamicSkuPricingInvocationHandler(this);
            Sku proxy = (Sku)Proxy.newProxyInstance(this.getClass().getClassLoader(), this.getClass().getInterfaces(), (InvocationHandler)handler);
            this.dynamicPrices = SkuPricingConsiderationContext.getSkuPricingService().getSkuPrices(proxy, SkuPricingConsiderationContext.getSkuPricingConsiderationContext());
            handler.reset();
            return this.dynamicPrices.getRetailPrice();
        }
        return this.retailPrice == null ? null : new Money(this.retailPrice);
    }

    @Override
    public void setRetailPrice(Money retailPrice) {
        this.retailPrice = Money.toAmount((Money)retailPrice);
    }

    @Override
    public Money getListPrice() {
        return new Money(this.retailPrice);
    }

    @Override
    public void setListPrice(Money listPrice) {
        this.retailPrice = Money.toAmount((Money)listPrice);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public Boolean isTaxable() {
        if (this.taxable == null) {
            return null;
        }
        return this.taxable.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getTaxable() {
        return this.isTaxable();
    }

    @Override
    public void setTaxable(Boolean taxable) {
        this.taxable = taxable == null ? null : Character.valueOf(taxable != false ? (char)'Y' : 'N');
    }

    @Override
    public Boolean isDiscountable() {
        if (this.discountable == null) {
            return null;
        }
        return this.discountable.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getDiscountable() {
        return this.isDiscountable();
    }

    @Override
    public void setDiscountable(Boolean discountable) {
        this.discountable = discountable == null ? null : Character.valueOf(discountable != false ? (char)'Y' : 'N');
    }

    @Override
    public Boolean isAvailable() {
        if (this.available == null) {
            return null;
        }
        return this.available.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getAvailable() {
        return this.isAvailable();
    }

    @Override
    public void setAvailable(Boolean available) {
        this.available = available == null ? null : Character.valueOf(available != false ? (char)'Y' : 'N');
    }

    @Override
    public Date getActiveStartDate() {
        return this.activeStartDate;
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    @Override
    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    @Override
    public boolean isActive() {
        if (LOG.isDebugEnabled() && !DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false)) {
            LOG.debug((Object)("sku, " + this.id + ", inactive due to date"));
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false);
    }

    @Override
    public boolean isActive(Product product, Category category) {
        if (LOG.isDebugEnabled()) {
            if (!DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false)) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to date"));
            } else if (!product.isActive()) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to product being inactive"));
            } else if (!category.isActive()) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to category being inactive"));
            }
        }
        return this.isActive() && product.isActive() && category.isActive();
    }

    @Override
    @Deprecated
    public Map<String, String> getSkuImages() {
        return this.skuImages;
    }

    @Override
    @Deprecated
    public String getSkuImage(String imageKey) {
        return this.skuImages.get(imageKey);
    }

    @Override
    @Deprecated
    public void setSkuImages(Map<String, String> skuImages) {
        this.skuImages = skuImages;
    }

    @Override
    public Map<String, Media> getSkuMedia() {
        return this.skuMedia;
    }

    @Override
    public void setSkuMedia(Map<String, Media> skuMedia) {
        this.skuMedia = skuMedia;
    }

    @Override
    public List<Product> getAllParentProducts() {
        return this.allParentProducts;
    }

    @Override
    public void setAllParentProducts(List<Product> allParentProducts) {
        this.allParentProducts = allParentProducts;
    }

    @Override
    public List<SkuAttribute> getSkuAttributes() {
        return this.skuAttributes;
    }

    @Override
    public void setSkuAttributes(List<SkuAttribute> skuAttributes) {
        this.skuAttributes = skuAttributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkuImpl other = (SkuImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }
}

