/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.broadleafcommerce.openadmin.client.presentation.SupportedFieldType;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.broadleafcommerce.profile.util.DimensionUnitOfMeasureType;
import org.broadleafcommerce.profile.vendor.service.type.ContainerShapeType;
import org.broadleafcommerce.profile.vendor.service.type.ContainerSizeType;

@Embeddable
public class ProductDimension
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="WIDTH")
    @AdminPresentation(friendlyName="Product Width", order=10, group="Dimension")
    protected BigDecimal width;
    @Column(name="HEIGHT")
    @AdminPresentation(friendlyName="Product Height", order=11, group="Dimension")
    protected BigDecimal height;
    @Column(name="DEPTH")
    @AdminPresentation(friendlyName="Product Depth", order=12, group="Dimension")
    protected BigDecimal depth;
    @Column(name="GIRTH")
    @AdminPresentation(friendlyName="Product Girth", order=13, group="Dimension")
    protected BigDecimal girth;
    @Column(name="CONTAINER_SIZE")
    @AdminPresentation(friendlyName="Product Container Size", order=14, group="Dimension", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.vendor.usps.service.type.USPSContainerSizeType")
    protected String size;
    @Column(name="CONTAINER_SHAPE")
    @AdminPresentation(friendlyName="Product Container Shape", order=15, group="Dimension", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.vendor.usps.service.type.USPSContainerShapeType")
    protected String container;
    @Column(name="DIMENSION_UNIT_OF_MEASURE")
    @AdminPresentation(friendlyName="Product Dimension Units", order=16, group="Dimension", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.profile.util.DimensionUnitOfMeasureType")
    protected String dimensionUnitOfMeasure;

    public BigDecimal getWidth() {
        return this.width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getHeight() {
        return this.height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public BigDecimal getDepth() {
        return this.depth;
    }

    public void setDepth(BigDecimal depth) {
        this.depth = depth;
    }

    public String getDimensionString() {
        return this.height + "Hx" + this.width + "Wx" + this.depth + "D\"";
    }

    public BigDecimal getGirth() {
        return this.girth;
    }

    public void setGirth(BigDecimal girth) {
        this.girth = girth;
    }

    public ContainerSizeType getSize() {
        return ContainerSizeType.getInstance((String)this.size);
    }

    public void setSize(ContainerSizeType size) {
        if (size != null) {
            this.size = size.getType();
        }
    }

    public ContainerShapeType getContainer() {
        return ContainerShapeType.getInstance((String)this.container);
    }

    public void setContainer(ContainerShapeType container) {
        if (container != null) {
            this.container = container.getType();
        }
    }

    public DimensionUnitOfMeasureType getDimensionUnitOfMeasure() {
        return DimensionUnitOfMeasureType.getInstance((String)this.dimensionUnitOfMeasure);
    }

    public void setDimensionUnitOfMeasure(DimensionUnitOfMeasureType dimensionUnitOfMeasure) {
        if (dimensionUnitOfMeasure != null) {
            this.dimensionUnitOfMeasure = dimensionUnitOfMeasure.getType();
        }
    }
}

