/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductAttribute;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT_ATTRIBUTE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class ProductAttributeImpl
implements ProductAttribute {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="ProductAttributeId")
    @GenericGenerator(name="ProductAttributeId", strategy="org.broadleafcommerce.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="ProductAttributeImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.ProductAttributeImpl")})
    @Column(name="PRODUCT_ATTRIBUTE_ID")
    protected Long id;
    @Column(name="NAME", nullable=false)
    @Index(name="PRODUCTATTRIBUTE_NAME_INDEX", columnNames={"NAME"})
    @AdminPresentation(friendlyName="Attribute Name", order=1, group="Description", prominent=true)
    protected String name;
    @Column(name="VALUE", nullable=false)
    @AdminPresentation(friendlyName="Attribute Value", order=2, group="Description", prominent=true)
    protected String value;
    @Column(name="SEARCHABLE")
    @AdminPresentation(friendlyName="Attribute Searchable", order=3, group="Description", prominent=true)
    protected Boolean searchable;
    @ManyToOne(targetEntity=ProductImpl.class, optional=false)
    @JoinColumn(name="PRODUCT_ID")
    @Index(name="PRODUCTATTRIBUTE_INDEX", columnNames={"PRODUCT_ID"})
    protected Product product;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public Boolean getSearchable() {
        return this.searchable;
    }

    @Override
    public void setSearchable(Boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public void setProduct(Product product) {
        this.product = product;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.product == null ? 0 : this.product.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductAttributeImpl other = (ProductAttributeImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.product == null ? other.product != null : !this.product.equals(other.product)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

