/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.FeaturedProduct;
import org.broadleafcommerce.core.catalog.domain.FeaturedProductImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.media.domain.Media;
import org.broadleafcommerce.core.media.domain.MediaImpl;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.broadleafcommerce.profile.cache.CacheFactoryException;
import org.broadleafcommerce.profile.cache.HydratedCacheManagerImpl;
import org.broadleafcommerce.profile.util.DateUtil;
import org.broadleafcommerce.profile.util.UrlUtil;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.OrderBy;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CATEGORY")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class CategoryImpl
implements Category {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(CategoryImpl.class);
    @Id
    @GeneratedValue(generator="CategoryId")
    @GenericGenerator(name="CategoryId", strategy="org.broadleafcommerce.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="CategoryImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.CategoryImpl")})
    @Column(name="CATEGORY_ID")
    @AdminPresentation(friendlyName="Category ID", group="Primary Key", hidden=true)
    protected Long id;
    @Column(name="NAME", nullable=false)
    @Index(name="CATEGORY_NAME_INDEX", columnNames={"NAME"})
    @AdminPresentation(friendlyName="Category Name", order=1, group="Description", prominent=true)
    protected String name;
    @Column(name="URL")
    @AdminPresentation(friendlyName="Category Url", order=2, group="Description")
    protected String url;
    @Column(name="URL_KEY")
    @Index(name="CATEGORY_URLKEY_INDEX", columnNames={"URL_KEY"})
    @AdminPresentation(friendlyName="Category Url Key", order=3, group="Description")
    protected String urlKey;
    @Column(name="DESCRIPTION")
    @AdminPresentation(friendlyName="Category Description", order=5, group="Description", largeEntry=true)
    protected String description;
    @Column(name="ACTIVE_START_DATE")
    @AdminPresentation(friendlyName="Category Active Start Date", order=7, group="Active Date Range")
    protected Date activeStartDate;
    @Column(name="ACTIVE_END_DATE")
    @AdminPresentation(friendlyName="Category Active End Date", order=8, group="Active Date Range")
    protected Date activeEndDate;
    @Column(name="DISPLAY_TEMPLATE")
    @AdminPresentation(friendlyName="Category Display Template", order=4, group="Description")
    protected String displayTemplate;
    @Column(name="LONG_DESCRIPTION")
    @AdminPresentation(friendlyName="Category Long Description", order=6, group="Description", largeEntry=true)
    protected String longDescription;
    @Transient
    protected Map<String, List<Category>> childCategoryURLMap;
    @Transient
    protected List<Category> childCategories = new ArrayList<Category>();
    @ManyToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="DEFAULT_PARENT_CATEGORY_ID")
    @Index(name="CATEGORY_PARENT_INDEX", columnNames={"DEFAULT_PARENT_CATEGORY_ID"})
    @AdminPresentation(friendlyName="Category Default Parent", order=7, group="Description")
    protected Category defaultParentCategory;
    @ManyToMany(targetEntity=CategoryImpl.class)
    @JoinTable(name="BLC_CATEGORY_XREF", joinColumns={@JoinColumn(name="CATEGORY_ID")}, inverseJoinColumns={@JoinColumn(name="SUB_CATEGORY_ID", referencedColumnName="CATEGORY_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @OrderBy(clause="DISPLAY_ORDER")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<Category> allChildCategories = new ArrayList<Category>();
    @ManyToMany(targetEntity=CategoryImpl.class)
    @JoinTable(name="BLC_CATEGORY_XREF", joinColumns={@JoinColumn(name="SUB_CATEGORY_ID")}, inverseJoinColumns={@JoinColumn(name="CATEGORY_ID", referencedColumnName="CATEGORY_ID", nullable=true)})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @OrderBy(clause="DISPLAY_ORDER")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<Category> allParentCategories = new ArrayList<Category>();
    @ManyToMany(targetEntity=ProductImpl.class)
    @JoinTable(name="BLC_CATEGORY_PRODUCT_XREF", joinColumns={@JoinColumn(name="CATEGORY_ID")}, inverseJoinColumns={@JoinColumn(name="PRODUCT_ID", nullable=true)})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @OrderBy(clause="DISPLAY_ORDER")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<Product> allProducts = new ArrayList<Product>();
    @CollectionOfElements
    @JoinTable(name="BLC_CATEGORY_IMAGE", joinColumns={@JoinColumn(name="CATEGORY_ID")})
    @MapKey(columns={@Column(name="NAME", length=5, nullable=false)})
    @Column(name="URL")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    @Deprecated
    protected Map<String, String> categoryImages = new HashMap<String, String>();
    @ManyToMany(targetEntity=MediaImpl.class)
    @JoinTable(name="BLC_CATEGORY_MEDIA_MAP", inverseJoinColumns={@JoinColumn(name="MEDIA_ID", referencedColumnName="MEDIA_ID")})
    @MapKey(columns={@Column(name="MAP_KEY", nullable=false)})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected Map<String, Media> categoryMedia = new HashMap<String, Media>();
    @OneToMany(mappedBy="category", targetEntity=FeaturedProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<FeaturedProduct> featuredProducts = new ArrayList<FeaturedProduct>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrlKey() {
        if ((this.urlKey == null || "".equals(this.urlKey.trim())) && this.getName() != null) {
            return UrlUtil.generateUrlKey((String)this.getName());
        }
        return this.urlKey;
    }

    @Override
    public String getGeneratedUrl() {
        return this.buildLink(null, this, false);
    }

    private String buildLink(String link, Category category, boolean ignoreTopLevel) {
        if (category == null || ignoreTopLevel && category.getDefaultParentCategory() == null) {
            return link;
        }
        String lLink = link == null ? category.getUrlKey() : category.getUrlKey() + "/" + link;
        return this.buildLink(lLink, category.getDefaultParentCategory(), ignoreTopLevel);
    }

    @Override
    public void setUrlKey(String urlKey) {
        this.urlKey = urlKey;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getActiveStartDate() {
        return this.activeStartDate;
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    @Override
    public Date getActiveEndDate() {
        return this.activeEndDate;
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    @Override
    public boolean isActive() {
        if (LOG.isDebugEnabled() && !DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false)) {
            LOG.debug((Object)("category, " + this.id + ", inactive due to date"));
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)false);
    }

    @Override
    public String getDisplayTemplate() {
        return this.displayTemplate;
    }

    @Override
    public void setDisplayTemplate(String displayTemplate) {
        this.displayTemplate = displayTemplate;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public Category getDefaultParentCategory() {
        return this.defaultParentCategory;
    }

    @Override
    public void setDefaultParentCategory(Category defaultParentCategory) {
        this.defaultParentCategory = defaultParentCategory;
    }

    @Override
    public List<Category> getAllChildCategories() {
        return this.allChildCategories;
    }

    @Override
    public boolean hasAllChildCategories() {
        return !this.allChildCategories.isEmpty();
    }

    @Override
    public void setAllChildCategories(List<Category> childCategories) {
        this.allChildCategories.clear();
        for (Category category : childCategories) {
            this.allChildCategories.add(category);
        }
    }

    @Override
    public List<Category> getChildCategories() {
        if (this.childCategories.isEmpty()) {
            for (Category category : this.allChildCategories) {
                if (!category.isActive()) continue;
                this.childCategories.add(category);
            }
        }
        return this.childCategories;
    }

    @Override
    public boolean hasChildCategories() {
        return this.getChildCategories().size() > 0;
    }

    @Override
    public void setChildCategories(List<Category> childCategories) {
        this.childCategories.clear();
        for (Category category : childCategories) {
            this.childCategories.add(category);
        }
    }

    @Override
    @Deprecated
    public Map<String, String> getCategoryImages() {
        return this.categoryImages;
    }

    @Override
    @Deprecated
    public String getCategoryImage(String imageKey) {
        return this.categoryImages.get(imageKey);
    }

    @Override
    @Deprecated
    public void setCategoryImages(Map<String, String> categoryImages) {
        this.categoryImages.clear();
        for (Map.Entry<String, String> me : categoryImages.entrySet()) {
            this.categoryImages.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public Map<String, List<Category>> getChildCategoryURLMap() {
        HydratedCacheManagerImpl manager = HydratedCacheManagerImpl.getInstance();
        Object hydratedItem = manager.getHydratedCacheElementItem("blStandardElements", CategoryImpl.class.getName(), (Serializable)this.getId(), "childCategoryURLMap");
        if (hydratedItem != null) {
            return (Map)hydratedItem;
        }
        this.childCategoryURLMap = this.createChildCategoryURLMap();
        manager.addHydratedCacheElementItem("blStandardElements", CategoryImpl.class.getName(), (Serializable)this.getId(), "childCategoryURLMap", this.childCategoryURLMap);
        return this.childCategoryURLMap;
    }

    @Override
    public void setChildCategoryURLMap(Map<String, List<Category>> cachedChildCategoryUrlMap) {
        this.childCategoryURLMap = cachedChildCategoryUrlMap;
    }

    public Map<String, List<Category>> createChildCategoryURLMap() {
        try {
            this.childCategoryURLMap = new HashMap<String, List<Category>>();
            HashMap<String, List<Category>> newMap = new HashMap<String, List<Category>>();
            this.fillInURLMapForCategory(newMap, this, "", new ArrayList<Category>());
            this.childCategoryURLMap = newMap;
            return this.childCategoryURLMap;
        }
        catch (CacheFactoryException e) {
            throw new RuntimeException(e);
        }
    }

    private void fillInURLMapForCategory(Map<String, List<Category>> categoryUrlMap, Category category, String startingPath, List<Category> startingCategoryList) throws CacheFactoryException {
        String urlKey = category.getUrlKey();
        if (urlKey == null) {
            throw new CacheFactoryException("Cannot create childCategoryURLMap - the urlKey for a category(" + category.getId() + ") was null");
        }
        String currentPath = startingPath + "/" + category.getUrlKey();
        ArrayList<Category> newCategoryList = new ArrayList<Category>(startingCategoryList);
        newCategoryList.add(category);
        category.getCategoryImages().size();
        category.getCategoryMedia().size();
        category.getAllParentCategories().size();
        category.getAllChildCategories().size();
        category.getFeaturedProducts().size();
        categoryUrlMap.put(currentPath, newCategoryList);
        for (Category currentCategory : category.getChildCategories()) {
            this.fillInURLMapForCategory(categoryUrlMap, currentCategory, currentPath, newCategoryList);
        }
    }

    @Override
    public List<Category> getAllParentCategories() {
        return this.allParentCategories;
    }

    @Override
    public void setAllParentCategories(List<Category> allParentCategories) {
        this.allParentCategories.clear();
        for (Category category : allParentCategories) {
            this.allParentCategories.add(category);
        }
    }

    @Override
    public List<FeaturedProduct> getFeaturedProducts() {
        return this.featuredProducts;
    }

    @Override
    public void setFeaturedProducts(List<FeaturedProduct> featuredProducts) {
        this.featuredProducts.clear();
        for (FeaturedProduct featuredProduct : featuredProducts) {
            this.featuredProducts.add(featuredProduct);
        }
    }

    @Override
    public List<Product> getAllProducts() {
        return this.allProducts;
    }

    @Override
    public void setAllProducts(List<Product> allProducts) {
        this.allProducts.clear();
        for (Product product : allProducts) {
            this.allProducts.add(product);
        }
    }

    @Override
    public Map<String, Media> getCategoryMedia() {
        return this.categoryMedia;
    }

    @Override
    public void setCategoryMedia(Map<String, Media> categoryMedia) {
        this.categoryMedia.clear();
        for (Map.Entry<String, Media> me : categoryMedia.entrySet()) {
            this.categoryMedia.put(me.getKey(), me.getValue());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryImpl other = (CategoryImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

