/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductSku;
import org.broadleafcommerce.core.catalog.service.type.ProductType;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.time.SystemTime;
import org.springframework.stereotype.Repository;

@Repository(value="blProductDao")
public class ProductDaoImpl
implements ProductDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected String queryCacheableKey = "org.hibernate.cacheable";
    protected Long currentDateResolution = 10000L;
    protected Date currentDate = SystemTime.asDate();

    @Override
    public Product save(Product product) {
        return (Product)this.em.merge((Object)product);
    }

    @Override
    public Product readProductById(Long productId) {
        return (Product)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.core.catalog.domain.Product"), (Object)productId);
    }

    @Override
    public List<Product> readProductsByName(String searchName) {
        Query query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_NAME");
        query.setParameter("name", (Object)(searchName + "%"));
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Product> readActiveProductsByCategory(Long categoryId, Date currentDate) {
        Date myDate;
        Date date = this.currentDate;
        synchronized (date) {
            if (currentDate.getTime() - this.currentDate.getTime() > this.currentDateResolution) {
                this.currentDate = currentDate;
                myDate = currentDate;
            } else {
                myDate = this.currentDate;
            }
        }
        Query query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_CATEGORY");
        query.setParameter("categoryId", (Object)categoryId);
        query.setParameter("currentDate", (Object)myDate);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsByCategory(Long categoryId) {
        Query query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_CATEGORY");
        query.setParameter("categoryId", (Object)categoryId);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsBySku(Long skuId) {
        Query query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_SKU");
        query.setParameter("skuId", (Object)skuId);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public List<ProductSku> readProductsBySkuOneToOne(Long skuId) {
        Query query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_SKU_ONE_TO_ONE");
        query.setParameter("skuId", (Object)skuId);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Product> readActiveProductsBySku(Long skuId, Date currentDate) {
        Date myDate;
        Date date = this.currentDate;
        synchronized (date) {
            if (currentDate.getTime() - this.currentDate.getTime() > this.currentDateResolution) {
                this.currentDate = currentDate;
                myDate = currentDate;
            } else {
                myDate = this.currentDate;
            }
        }
        Query query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_SKU");
        query.setParameter("skuId", (Object)skuId);
        query.setParameter("currentDate", (Object)myDate);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProductSku> readActiveProductsBySkuOneToOne(Long skuId, Date currentDate) {
        Date myDate;
        Date date = this.currentDate;
        synchronized (date) {
            if (currentDate.getTime() - this.currentDate.getTime() > this.currentDateResolution) {
                this.currentDate = currentDate;
                myDate = currentDate;
            } else {
                myDate = this.currentDate;
            }
        }
        Query query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_SKU_ONE_TO_ONE");
        query.setParameter("skuId", (Object)skuId);
        query.setParameter("currentDate", (Object)myDate);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public void delete(Product product) {
        if (!this.em.contains((Object)product)) {
            product = this.readProductById(product.getId());
        }
        this.em.remove((Object)product);
    }

    @Override
    public Product create(ProductType productType) {
        Product item = (Product)this.entityConfiguration.createEntityInstance(productType.getType());
        return item;
    }

    public String getQueryCacheableKey() {
        return this.queryCacheableKey;
    }

    public void setQueryCacheableKey(String queryCacheableKey) {
        this.queryCacheableKey = queryCacheableKey;
    }

    public Long getCurrentDateResolution() {
        return this.currentDateResolution;
    }

    public void setCurrentDateResolution(Long currentDateResolution) {
        this.currentDateResolution = currentDateResolution;
    }
}

