/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.core.catalog.dao.CategoryXrefDao;
import org.broadleafcommerce.core.catalog.domain.CategoryXref;
import org.broadleafcommerce.core.catalog.domain.CategoryXrefImpl;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blCategoryXrefDao")
public class CategoryXrefDaoImpl
implements CategoryXrefDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected String queryCacheableKey = "org.hibernate.cacheable";

    @Override
    public List<CategoryXrefImpl> readXrefsByCategoryId(Long categoryId) {
        Query query = this.em.createNamedQuery("BC_READ_CATEGORY_XREF_BY_CATEGORYID");
        query.setParameter("categoryId", (Object)categoryId);
        return query.getResultList();
    }

    @Override
    public List<CategoryXrefImpl> readXrefsBySubCategoryId(Long subCategoryId) {
        Query query = this.em.createNamedQuery("BC_READ_CATEGORY_XREF_BY_SUBCATEGORYID");
        query.setParameter("subCategoryId", (Object)subCategoryId);
        return query.getResultList();
    }

    @Override
    public CategoryXrefImpl readXrefByIds(Long categoryId, Long subCategoryId) {
        Query query = this.em.createNamedQuery("BC_READ_CATEGORY_XREF_BY_IDS");
        query.setParameter("categoryId", (Object)categoryId);
        query.setParameter("subCategoryId", (Object)subCategoryId);
        return (CategoryXrefImpl)query.getSingleResult();
    }

    @Override
    public CategoryXref save(CategoryXrefImpl categoryXref) {
        return (CategoryXref)this.em.merge((Object)categoryXref);
    }

    @Override
    public void delete(CategoryXrefImpl categoryXref) {
        if (!this.em.contains((Object)categoryXref)) {
            categoryXref = this.readXrefByIds(categoryXref.getCategoryXrefPK().getCategory().getId(), categoryXref.getCategoryXrefPK().getSubCategory().getId());
        }
        this.em.remove((Object)categoryXref);
    }

    public String getQueryCacheableKey() {
        return this.queryCacheableKey;
    }

    public void setQueryCacheableKey(String queryCacheableKey) {
        this.queryCacheableKey = queryCacheableKey;
    }
}

