/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blCategoryDao")
public class CategoryDaoImpl
implements CategoryDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected String queryCacheableKey = "org.hibernate.cacheable";

    @Override
    public Category save(Category category) {
        return (Category)this.em.merge((Object)category);
    }

    @Override
    public Category readCategoryById(Long categoryId) {
        return (Category)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.core.catalog.domain.Category"), (Object)categoryId);
    }

    @Override
    public Category readCategoryByName(String categoryName) {
        Query query = this.em.createNamedQuery("BC_READ_CATEGORY_BY_NAME");
        query.setParameter("categoryName", (Object)categoryName);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return (Category)query.getSingleResult();
    }

    @Override
    public List<Category> readAllCategories() {
        Query query = this.em.createNamedQuery("BC_READ_ALL_CATEGORIES");
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public List<Product> readAllProducts() {
        Query query = this.em.createNamedQuery("BC_READ_ALL_PRODUCTS");
        return query.getResultList();
    }

    @Override
    public List<Category> readAllSubCategories(Category category) {
        Query query = this.em.createNamedQuery("BC_READ_ALL_SUBCATEGORIES");
        query.setParameter("defaultParentCategory", (Object)category);
        return query.getResultList();
    }

    public String getQueryCacheableKey() {
        return this.queryCacheableKey;
    }

    public void setQueryCacheableKey(String queryCacheableKey) {
        this.queryCacheableKey = queryCacheableKey;
    }

    @Override
    public void delete(Category category) {
        if (!this.em.contains((Object)category)) {
            category = this.readCategoryById(category.getId());
        }
        this.em.remove((Object)category);
    }

    @Override
    public Category create() {
        Category category = (Category)this.entityConfiguration.createEntityInstance(Category.class.getName());
        return category;
    }
}

