/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.workflow;

import java.util.List;
import org.broadleafcommerce.workflow.Activity;
import org.broadleafcommerce.workflow.ErrorHandler;
import org.broadleafcommerce.workflow.Processor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public abstract class BaseProcessor
implements InitializingBean,
BeanNameAware,
BeanFactoryAware,
Processor {
    private BeanFactory beanFactory;
    private String beanName;
    private List<Activity> activities;
    private ErrorHandler defaultErrorHandler;

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (!(this.beanFactory instanceof ListableBeanFactory)) {
            throw new BeanInitializationException("The workflow processor [" + this.beanName + "] " + "is not managed by a ListableBeanFactory, please re-deploy using some dirivative of ListableBeanFactory such as" + "ClassPathXmlApplicationContext ");
        }
        if (this.activities == null || this.activities.isEmpty()) {
            throw new UnsatisfiedDependencyException(this.getBeanDesc(), this.beanName, "activities", "No activities were wired for this workflow");
        }
        for (Activity activitiy : this.activities) {
            if (this.supports(activitiy)) continue;
            throw new BeanInitializationException("The workflow processor [" + this.beanName + "] does " + "not support the activity of type" + activitiy.getClass().getName());
        }
    }

    protected String getBeanDesc() {
        return this.beanFactory instanceof ConfigurableListableBeanFactory ? ((ConfigurableListableBeanFactory)this.beanFactory).getBeanDefinition(this.beanName).getResourceDescription() : "Workflow Processor: " + this.beanName;
    }

    @Override
    public void setActivities(List<Activity> activities) {
        this.activities = activities;
    }

    @Override
    public void setDefaultErrorHandler(ErrorHandler defaultErrorHandler) {
        this.defaultErrorHandler = defaultErrorHandler;
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public ErrorHandler getDefaultErrorHandler() {
        return this.defaultErrorHandler;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }
}

