/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.store.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.store.dao.StoreDao;
import org.broadleafcommerce.store.domain.Store;
import org.springframework.stereotype.Repository;

@Repository(value="blStoreDao")
public class StoreDaoImpl
implements StoreDao {
    @PersistenceContext(unitName="blPU")
    private EntityManager em;

    @Override
    public Store readStoreByStoreCode(String storeCode) {
        Query query = this.em.createNamedQuery("FIND_STORE_BY_STORE_CODE");
        query.setParameter("abbreviation", (Object)storeCode.toUpperCase());
        query.setHint("org.hibernate.cacheable", (Object)true);
        List result = query.getResultList();
        return result.size() > 0 ? (Store)result.get(0) : null;
    }

    @Override
    public List<Store> readAllStores() {
        Query query = this.em.createNamedQuery("BC_FIND_ALL_STORES");
        query.setHint("org.hibernate.cacheable", (Object)true);
        List results = query.getResultList();
        return results;
    }
}

