/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.security.domain;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.security.domain.AdminRole;
import org.broadleafcommerce.security.domain.AdminRoleImpl;
import org.broadleafcommerce.security.domain.AdminUser;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ADMIN_USER")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class AdminUserImpl
implements AdminUser {
    @Id
    @GeneratedValue(generator="AdminUserId", strategy=GenerationType.TABLE)
    @TableGenerator(name="AdminUserId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="AdminUserImpl", allocationSize=50)
    @Column(name="ADMIN_USER_ID")
    private Long id;
    @Column(name="NAME", nullable=false)
    protected String name;
    @Column(name="LOGIN", nullable=false)
    protected String login;
    @Column(name="PASSWORD", nullable=false)
    protected String password;
    @Column(name="EMAIL", nullable=false)
    protected String email;
    @ManyToMany(fetch=FetchType.EAGER, targetEntity=AdminRoleImpl.class)
    @JoinTable(name="BLC_ADMIN_USER_ROLE_XREF", joinColumns={@JoinColumn(name="ADMIN_USER_ID", referencedColumnName="ADMIN_USER_ID")}, inverseJoinColumns={@JoinColumn(name="ADMIN_ROLE_ID", referencedColumnName="ADMIN_ROLE_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=50)
    protected Set<AdminRole> allRoles = new HashSet<AdminRole>();

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(String login) {
        this.login = login;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    public Set<AdminRole> getAllRoles() {
        return this.allRoles;
    }

    public void setAllRoles(Set<AdminRole> allRoles) {
        this.allRoles = allRoles;
    }
}

