/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.security.domain;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.security.domain.AdminPermission;
import org.broadleafcommerce.security.domain.AdminPermissionImpl;
import org.broadleafcommerce.security.domain.AdminRole;
import org.broadleafcommerce.security.domain.AdminUser;
import org.broadleafcommerce.security.domain.AdminUserImpl;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ADMIN_ROLE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class AdminRoleImpl
implements AdminRole {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="AdminRoleId", strategy=GenerationType.TABLE)
    @TableGenerator(name="AdminRoleId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="AdminRoleImpl", allocationSize=50)
    @Column(name="ADMIN_ROLE_ID")
    protected Long id;
    @Column(name="NAME", nullable=false)
    protected String name;
    @Column(name="DESCRIPTION", nullable=false)
    protected String description;
    @ManyToMany(fetch=FetchType.EAGER, targetEntity=AdminUserImpl.class)
    @JoinTable(name="BLC_ADMIN_USER_ROLE_XREF", joinColumns={@JoinColumn(name="ADMIN_ROLE_ID", referencedColumnName="ADMIN_ROLE_ID")}, inverseJoinColumns={@JoinColumn(name="ADMIN_USER_ID", referencedColumnName="ADMIN_USER_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=50)
    protected Set<AdminUser> allUsers = new HashSet<AdminUser>();
    @ManyToMany(fetch=FetchType.EAGER, targetEntity=AdminPermissionImpl.class)
    @JoinTable(name="BLC_ADMIN_ROLE_PERMISSION_XREF", joinColumns={@JoinColumn(name="ADMIN_ROLE_ID", referencedColumnName="ADMIN_ROLE_ID")}, inverseJoinColumns={@JoinColumn(name="ADMIN_PERMISSION_ID", referencedColumnName="ADMIN_PERMISSION_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @BatchSize(size=50)
    protected Set<AdminPermission> allPermissions = new HashSet<AdminPermission>();

    public Set<AdminPermission> getAllPermissions() {
        return this.allPermissions;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Set<AdminUser> getAllUsers() {
        return this.allUsers;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public void setAllPermissions(Set<AdminPermission> allPermissions) {
        this.allPermissions = allPermissions;
    }
}

