/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.security.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.broadleafcommerce.security.dao.AdminUserDao;
import org.broadleafcommerce.security.domain.AdminUser;
import org.springframework.stereotype.Repository;

@Repository(value="blAdminUserDao")
public class AdminUserDaoImpl
implements AdminUserDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource
    protected EntityConfiguration entityConfiguration;
    protected String queryCacheableKey = "org.hibernate.cacheable";

    @Override
    public void deleteAdminUser(AdminUser user) {
        AdminUser persisted = (AdminUser)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.security.domain.AdminUser"), (Object)user.getId());
        this.em.remove((Object)persisted);
    }

    @Override
    public AdminUser readAdminUserById(Long id) {
        return (AdminUser)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.security.domain.AdminUser"), (Object)id);
    }

    @Override
    public AdminUser saveAdminUser(AdminUser user) {
        if (user.getId() == null) {
            this.em.persist((Object)user);
        } else {
            user = (AdminUser)this.em.merge((Object)user);
        }
        return user;
    }

    @Override
    public AdminUser readAdminUserByUserName(String userName) {
        Query query = this.em.createNamedQuery("BC_READ_ADMIN_USER_BY_USERNAME");
        query.setParameter("userName", (Object)userName);
        List users = query.getResultList();
        if (users != null && !users.isEmpty()) {
            return (AdminUser)users.get(0);
        }
        return null;
    }

    @Override
    public List<AdminUser> readAllAdminUsers() {
        Query query = this.em.createNamedQuery("BC_READ_ALL_ADMIN_USERS");
        List users = query.getResultList();
        return users;
    }
}

