/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.search.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.lang.ArrayUtils;
import org.broadleafcommerce.catalog.domain.Product;
import org.broadleafcommerce.util.money.Money;

public class SearchFilterUtil {
    public static void filterProducts(List<Product> products, Map<String, String[]> parameters, String[] allowedParameters) {
        for (String parameter : allowedParameters) {
            BeanToPropertyValueTransformer reader = new BeanToPropertyValueTransformer(parameter, true);
            if (parameters.containsKey(parameter)) {
                Iterator<Product> itr = products.iterator();
                while (itr.hasNext()) {
                    Product product = itr.next();
                    if (ArrayUtils.contains((Object[])parameters.get(parameter), (Object)reader.transform((Object)product).toString())) continue;
                    itr.remove();
                }
                continue;
            }
            if (!parameters.containsKey("min-" + parameter)) continue;
            String minMoney = parameters.get("min-" + parameter)[0];
            String maxMoney = parameters.get("max-" + parameter)[0];
            Money minimumMoney = new Money(minMoney.replaceAll("[^0-9.]", ""));
            Money maximumMoney = new Money(maxMoney.replaceAll("[^0-9.]", ""));
            Iterator<Product> itr = products.iterator();
            while (itr.hasNext()) {
                Product product = itr.next();
                Money objectValue = (Money)reader.transform((Object)product);
                if (!objectValue.lessThan(minimumMoney) && !objectValue.greaterThan(maximumMoney)) continue;
                itr.remove();
            }
        }
    }
}

