/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.search.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.broadleafcommerce.catalog.domain.Product;
import org.broadleafcommerce.catalog.service.CatalogService;
import org.broadleafcommerce.search.service.SearchService;
import org.compass.core.Compass;
import org.compass.core.CompassContext;
import org.compass.core.CompassDetachedHits;
import org.compass.core.CompassIndexSession;
import org.compass.core.CompassSearchSession;
import org.compass.core.engine.SearchEngineIndexManager;
import org.springframework.stereotype.Service;

@Service(value="blSearchService")
public class SearchServiceCompassImpl
implements SearchService {
    @CompassContext
    protected Compass compass;
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    private Logger logger = Logger.getLogger(this.getClass());

    @Override
    public List<Product> performSearch(String input) {
        CompassSearchSession session = this.compass.openSearchSession();
        CompassDetachedHits hits = session.find(input).detach();
        session.close();
        ArrayList<Product> results = new ArrayList<Product>(hits.length());
        for (int i = 0; i < hits.length(); ++i) {
            Product resourceProduct = (Product)hits.data(i);
            results.add(this.catalogService.findProductById(resourceProduct.getId()));
        }
        return results;
    }

    @Override
    public void rebuildProductIndex() {
        this.logger.info((Object)"Rebuilding product index");
        List<Product> products = this.catalogService.findAllProducts();
        SearchEngineIndexManager manager = this.compass.getSearchEngineIndexManager();
        if (!manager.indexExists()) {
            manager.createIndex();
        }
        CompassIndexSession session = this.compass.openIndexSession();
        for (Product product : products) {
            session.save((Object)product);
        }
        session.commit();
        session.close();
    }
}

