/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.rating.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanComparator;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.rating.dao.RatingSummaryDao;
import org.broadleafcommerce.rating.dao.ReviewDetailDao;
import org.broadleafcommerce.rating.domain.RatingDetailImpl;
import org.broadleafcommerce.rating.domain.RatingSummary;
import org.broadleafcommerce.rating.domain.RatingSummaryImpl;
import org.broadleafcommerce.rating.domain.ReviewDetail;
import org.broadleafcommerce.rating.domain.ReviewDetailImpl;
import org.broadleafcommerce.rating.domain.ReviewFeedbackImpl;
import org.broadleafcommerce.rating.service.RatingService;
import org.broadleafcommerce.rating.service.type.RatingSortType;
import org.broadleafcommerce.rating.service.type.RatingType;
import org.broadleafcommerce.time.SystemTime;

public class RatingServiceImpl
implements RatingService {
    @Resource
    private RatingSummaryDao ratingSummaryDao;
    @Resource
    private ReviewDetailDao reviewDetailDao;

    @Override
    public void deleteRatingSummary(RatingSummary ratingSummary) {
        this.ratingSummaryDao.deleteRatingSummary(ratingSummary);
    }

    @Override
    public void markReviewHelpful(Long reviewId, Customer customer, Boolean helpful) {
        ReviewDetail reviewDetail = this.reviewDetailDao.readReviewDetailById(reviewId);
        if (reviewDetail != null) {
            ReviewFeedbackImpl reviewFeedback = new ReviewFeedbackImpl(customer, helpful, reviewDetail);
            reviewDetail.getReviewFeedback().add(reviewFeedback);
            this.reviewDetailDao.saveReviewDetail(reviewDetail);
        }
    }

    @Override
    public void rateItem(String itemId, RatingType type, Customer customer, Double rating) {
        RatingSummary ratingSummary = this.readRatingSummary(itemId, type);
        if (ratingSummary == null) {
            ratingSummary = new RatingSummaryImpl(itemId, type);
        }
        RatingDetailImpl ratingDetail = new RatingDetailImpl(ratingSummary, rating, SystemTime.asDate(), customer);
        ratingSummary.getRatings().add(ratingDetail);
        this.ratingSummaryDao.saveRatingSummary(ratingSummary);
    }

    @Override
    public RatingSummary readRatingSummary(String itemId, RatingType type) {
        return this.ratingSummaryDao.readRatingSummary(itemId, type);
    }

    @Override
    public Map<String, RatingSummary> readRatingSummaries(List<String> itemIds, RatingType type) {
        List<RatingSummary> ratings = this.ratingSummaryDao.readRatingSummaries(itemIds, type);
        HashMap<String, RatingSummary> ratingsMap = new HashMap<String, RatingSummary>();
        for (RatingSummary ratingSummary : ratings) {
            ratingsMap.put(ratingSummary.getItemId(), ratingSummary);
        }
        return ratingsMap;
    }

    @Override
    public List<ReviewDetail> readReviews(String itemId, RatingType type, int start, int finish, RatingSortType sortBy) {
        RatingSummary summary = this.readRatingSummary(itemId, type);
        List<ReviewDetail> reviews = summary.getReviews();
        ArrayList<ReviewDetail> reviewsToReturn = new ArrayList<ReviewDetail>();
        int i = 0;
        for (ReviewDetail review : reviews) {
            if (i > finish) break;
            if (i >= start) {
                reviewsToReturn.add(review);
            }
            ++i;
        }
        String sortByBeanProperty = "reviewSubmittedDate";
        if (sortBy == RatingSortType.MOST_HELPFUL) {
            sortByBeanProperty = "helpfulCount";
        }
        Collections.sort(reviewsToReturn, new BeanComparator(sortByBeanProperty));
        return reviewsToReturn;
    }

    @Override
    public RatingSummary saveRatingSummary(RatingSummary ratingSummary) {
        return this.ratingSummaryDao.saveRatingSummary(ratingSummary);
    }

    @Override
    public void reviewItem(String itemId, RatingType type, Customer customer, String reviewText) {
        RatingSummary ratingSummary = this.readRatingSummary(itemId, type);
        if (ratingSummary == null) {
            ratingSummary = new RatingSummaryImpl(itemId, type);
        }
        ReviewDetailImpl reviewDetail = new ReviewDetailImpl(customer, SystemTime.asDate(), reviewText, ratingSummary);
        ratingSummary.getReviews().add(reviewDetail);
        this.ratingSummaryDao.saveRatingSummary(ratingSummary);
    }
}

