/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.rating.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.profile.domain.CustomerImpl;
import org.broadleafcommerce.rating.domain.ReviewDetail;
import org.broadleafcommerce.rating.domain.ReviewDetailImpl;
import org.broadleafcommerce.rating.domain.ReviewFeedback;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_REVIEW_FEEDBACK")
public class ReviewFeedbackImpl
implements ReviewFeedback {
    @Id
    @GeneratedValue(generator="ReviewFeedbackId", strategy=GenerationType.TABLE)
    @TableGenerator(name="ReviewFeedbackId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="ReviewFeedbackImpl", allocationSize=50)
    @Column(name="REVIEW_FEEDBACK_ID")
    protected Long id;
    @ManyToOne(targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID")
    protected Customer customer;
    @Column(name="IS_HELPFUL", nullable=false)
    protected Boolean isHelpful;
    @ManyToOne(optional=false, targetEntity=ReviewDetailImpl.class)
    @JoinColumn(name="REVIEW_DETAIL_ID")
    protected ReviewDetail reviewDetail;

    @Override
    public Long getId() {
        return this.id;
    }

    public ReviewFeedbackImpl(Customer customer, Boolean isHelpful, ReviewDetail reviewDetail) {
        this.customer = customer;
        this.isHelpful = isHelpful;
        this.reviewDetail = reviewDetail;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public Boolean isHelpful() {
        return this.isHelpful;
    }

    @Override
    public ReviewDetail getReviewDetail() {
        return this.reviewDetail;
    }
}

