/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.rating.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.profile.domain.CustomerImpl;
import org.broadleafcommerce.rating.domain.RatingSummary;
import org.broadleafcommerce.rating.domain.RatingSummaryImpl;
import org.broadleafcommerce.rating.domain.ReviewDetail;
import org.broadleafcommerce.rating.domain.ReviewFeedback;
import org.broadleafcommerce.rating.domain.ReviewFeedbackImpl;
import org.broadleafcommerce.rating.service.type.ReviewStatusType;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_REVIEW_DETAIL")
public class ReviewDetailImpl
implements ReviewDetail {
    @Id
    @GeneratedValue(generator="ReviewDetailId", strategy=GenerationType.TABLE)
    @TableGenerator(name="ReviewDetailId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="ReviewDetailImpl", allocationSize=50)
    @Column(name="REVIEW_DETAIL_ID")
    private Long id;
    @ManyToOne(targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID")
    protected Customer customer;
    @Column(name="REVIEW_SUBMITTED_DATE", nullable=false)
    protected Date reivewSubmittedDate;
    @Column(name="REVIEW_TEXT", nullable=false)
    protected String reviewText;
    @Column(name="REVIEW_STATUS", nullable=false)
    protected String reviewStatus;
    @Column(name="HELPFUL_COUNT", nullable=false)
    protected Integer helpfulCount;
    @Column(name="NOT_HELPFUL_COUNT", nullable=false)
    protected Integer notHelpfulCount;
    @ManyToOne(optional=false, targetEntity=RatingSummaryImpl.class)
    @JoinColumn(name="RATING_SUMMARY_ID")
    protected RatingSummary ratingSummary;
    @OneToMany(mappedBy="reviewDetail", targetEntity=ReviewFeedbackImpl.class)
    protected List<ReviewFeedback> reviewFeedback;

    public ReviewDetailImpl(Customer customer, Date reivewSubmittedDate, String reviewText, RatingSummary ratingSummary) {
        this.customer = customer;
        this.reivewSubmittedDate = reivewSubmittedDate;
        this.reviewText = reviewText;
        this.ratingSummary = ratingSummary;
        this.reviewFeedback = new ArrayList<ReviewFeedback>();
    }

    @Override
    public Date getReviewSubmittedDate() {
        return this.reivewSubmittedDate;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getReviewText() {
        return this.reviewText;
    }

    @Override
    public ReviewStatusType getStatus() {
        return new ReviewStatusType(this.reviewStatus);
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public Integer helpfulCount() {
        return this.helpfulCount;
    }

    @Override
    public Integer notHelpfulCount() {
        return this.notHelpfulCount;
    }

    @Override
    public RatingSummary getRatingSummary() {
        return this.ratingSummary;
    }

    @Override
    public List<ReviewFeedback> getReviewFeedback() {
        return this.reviewFeedback == null ? new ArrayList() : this.reviewFeedback;
    }
}

