/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.rating.domain;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.rating.domain.RatingDetail;
import org.broadleafcommerce.rating.domain.RatingDetailImpl;
import org.broadleafcommerce.rating.domain.RatingSummary;
import org.broadleafcommerce.rating.domain.ReviewDetail;
import org.broadleafcommerce.rating.domain.ReviewDetailImpl;
import org.broadleafcommerce.rating.service.type.RatingType;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_RATING_SUMMARY")
public class RatingSummaryImpl
implements RatingSummary {
    @Id
    @GeneratedValue(generator="RatingSummaryId", strategy=GenerationType.TABLE)
    @TableGenerator(name="RatingSummaryId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="RatingSummaryImpl", allocationSize=50)
    @Column(name="RATING_SUMMARY_ID")
    private Long id;
    @Column(name="ITEM_ID", nullable=false)
    private String itemId;
    @Column(name="RATING_TYPE", nullable=false)
    private String ratingType;
    @Column(name="AVERAGE_RATING", nullable=false)
    protected Double averageRating;
    @OneToMany(mappedBy="ratingSummary", targetEntity=RatingDetailImpl.class)
    protected List<RatingDetail> ratings;
    @OneToMany(mappedBy="ratingSummary", targetEntity=ReviewDetailImpl.class)
    protected List<ReviewDetail> reviews;

    public RatingSummaryImpl(String itemId, RatingType ratingType) {
        this.itemId = itemId;
        this.ratingType = ratingType.getType();
        this.ratings = new ArrayList<RatingDetail>();
        this.reviews = new ArrayList<ReviewDetail>();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Double getAverageRating() {
        return this.averageRating;
    }

    @Override
    public String getItemId() {
        return this.itemId;
    }

    @Override
    public Integer getNumberOfRatings() {
        return this.getRatings().size();
    }

    @Override
    public Integer getNumberOfReviews() {
        return this.getReviews().size();
    }

    @Override
    public RatingType getRatingType() {
        return new RatingType(this.ratingType);
    }

    @Override
    public List<RatingDetail> getRatings() {
        return this.ratings == null ? new ArrayList() : this.ratings;
    }

    @Override
    public List<ReviewDetail> getReviews() {
        return this.reviews == null ? new ArrayList() : this.reviews;
    }

    @Override
    public void resetAverageRating() {
        double sum = 0.0;
        for (RatingDetail detail : this.ratings) {
            sum += detail.getRating().doubleValue();
        }
        this.averageRating = sum / (double)this.ratings.size();
    }
}

