/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.rating.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.broadleafcommerce.rating.dao.RatingSummaryDao;
import org.broadleafcommerce.rating.domain.RatingSummary;
import org.broadleafcommerce.rating.service.type.RatingType;
import org.springframework.stereotype.Repository;

@Repository(value="blRatingSummaryDao")
public class RatingSummaryDaoImpl
implements RatingSummaryDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource
    protected EntityConfiguration entityConfiguration;
    protected String queryCacheableKey = "org.hibernate.cacheable";

    @Override
    public void deleteRatingSummary(RatingSummary summary) {
        this.em.remove((Object)summary);
    }

    @Override
    public RatingSummary saveRatingSummary(RatingSummary summary) {
        summary.resetAverageRating();
        if (summary.getId() == null) {
            this.em.persist((Object)summary);
        } else {
            summary = (RatingSummary)this.em.merge((Object)summary);
        }
        return summary;
    }

    @Override
    public List<RatingSummary> readRatingSummaries(List<String> itemIds, RatingType type) {
        Query query = this.em.createNamedQuery("BC_READ_RATING_SUMMARIES_BY_ITEM_ID_AND_TYPE");
        query.setParameter("itemIds", itemIds);
        query.setParameter("ratingType", (Object)type);
        List ratings = query.getResultList();
        return ratings;
    }

    @Override
    public RatingSummary readRatingSummary(String itemId, RatingType type) {
        Query query = this.em.createNamedQuery("BC_READ_RATING_SUMMARIES_BY_ITEM_ID_AND_TYPE");
        query.setParameter("itemId", (Object)itemId);
        query.setParameter("ratingType", (Object)type);
        RatingSummary ratingSummary = (RatingSummary)query.getSingleResult();
        return ratingSummary;
    }
}

