/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.pricing.service.workflow;

import java.math.BigDecimal;
import org.broadleafcommerce.order.domain.FulfillmentGroup;
import org.broadleafcommerce.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.pricing.service.workflow.PricingContext;
import org.broadleafcommerce.util.money.Money;
import org.broadleafcommerce.workflow.BaseActivity;
import org.broadleafcommerce.workflow.ProcessContext;

public class TotalActivity
extends BaseActivity {
    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        Order order = ((PricingContext)context).getSeedData();
        Money total = new Money(BigDecimal.ZERO);
        total = total.add(order.getSubTotal());
        total = total.add(order.getTotalTax());
        total = total.add(order.getTotalShipping());
        Money fees = new Money(BigDecimal.ZERO);
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            Money fgTotal = new Money(0.0);
            fgTotal = fgTotal.add(fulfillmentGroup.getMerchandiseTotal());
            fgTotal = fgTotal.add(fulfillmentGroup.getShippingPrice());
            fgTotal = fgTotal.add(fulfillmentGroup.getTotalTax());
            for (FulfillmentGroupFee fulfillmentGroupFee : fulfillmentGroup.getFulfillmentGroupFees()) {
                fgTotal = fgTotal.add(fulfillmentGroupFee.getAmount());
                fees = fees.add(fulfillmentGroupFee.getAmount());
            }
            fulfillmentGroup.setTotal(fgTotal);
        }
        total = total.add(fees);
        order.setTotal(total);
        context.setSeedData(order);
        return context;
    }
}

