/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.pricing.service.module;

import org.broadleafcommerce.order.domain.FulfillmentGroup;
import org.broadleafcommerce.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.pricing.service.module.TaxModule;
import org.broadleafcommerce.util.money.Money;

public class SimpleTaxModule
implements TaxModule {
    public static final String MODULENAME = "simpleTaxModule";
    protected String name = "simpleTaxModule";
    protected Double factor;

    @Override
    public Order calculateTaxForOrder(Order order) {
        Money orderSubtotal = order.getSubTotal();
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupFee fulfillmentGroupFee : fulfillmentGroup.getFulfillmentGroupFees()) {
                if (!fulfillmentGroupFee.isTaxable()) continue;
                orderSubtotal = orderSubtotal.add(fulfillmentGroupFee.getAmount());
            }
        }
        Money totalTax = orderSubtotal.multiply(this.factor.doubleValue());
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            Money fgTotalTax = fulfillmentGroup.getShippingPrice().multiply(this.factor.doubleValue());
            fulfillmentGroup.setTotalTax(fgTotalTax);
            fulfillmentGroup.setCityTax(new Money(0.0));
            fulfillmentGroup.setCountyTax(new Money(0.0));
            fulfillmentGroup.setCountryTax(new Money(0.0));
            totalTax = totalTax.add(fgTotalTax);
        }
        order.setTotalTax(totalTax);
        return order;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Double getFactor() {
        return this.factor;
    }

    public void setFactor(Double factor) {
        this.factor = factor;
    }
}

