/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.pricing.service.advice;

import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.broadleafcommerce.order.dao.OrderDao;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.pricing.service.PricingService;
import org.broadleafcommerce.pricing.service.advice.PricingExecutionManager;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component(value="blPricingExecutionManager")
public class PricingExecutionManagerImpl
implements PricingExecutionManager,
Ordered {
    private static final Log LOG = LogFactory.getLog(PricingExecutionManagerImpl.class);
    private static final ThreadLocal<Order> uniqueOrder = new ThreadLocal();
    private int order;
    @Resource(name="blPricingService")
    private PricingService pricingService;
    @Resource(name="blOrderDao")
    private OrderDao orderDao;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void clearCache() {
        uniqueOrder.remove();
    }

    @Override
    public void executePricing(Order order) {
        uniqueOrder.set(order);
        LOG.debug((Object)("Context order reset : order id " + order.getId()));
    }

    public Order getLatestItem() {
        Order order = uniqueOrder.get();
        if (order != null) {
            LOG.debug((Object)("Latest context order retrieved : order id " + order.getId()));
        }
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object priceOrder(ProceedingJoinPoint call) throws Throwable {
        Object returnValue;
        this.clearCache();
        try {
            returnValue = call.proceed();
        }
        finally {
            Order orderItem = this.getLatestItem();
            this.clearCache();
            if (orderItem != null) {
                this.orderDao.save(orderItem);
                orderItem = this.pricingService.executePricing(orderItem);
                this.orderDao.save(orderItem);
                LOG.debug((Object)("Context order priced : order id " + orderItem.getId()));
            }
        }
        return returnValue;
    }
}

