/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.pricing.service;

import javax.annotation.Resource;
import org.broadleafcommerce.order.domain.Order;
import org.broadleafcommerce.pricing.service.PricingService;
import org.broadleafcommerce.pricing.service.exception.PricingException;
import org.broadleafcommerce.pricing.service.workflow.PricingContext;
import org.broadleafcommerce.workflow.SequenceProcessor;
import org.broadleafcommerce.workflow.WorkflowException;
import org.springframework.stereotype.Service;

@Service(value="blPricingService")
public class PricingServiceImpl
implements PricingService {
    @Resource(name="blPricingWorkflow")
    protected SequenceProcessor pricingWorkflow;

    @Override
    public Order executePricing(Order order) throws PricingException {
        try {
            PricingContext context = (PricingContext)this.pricingWorkflow.doActivities(order);
            Order response = context.getSeedData();
            return response;
        }
        catch (WorkflowException e) {
            throw new PricingException("Unable to execute pricing for order -- id: " + order.getId(), e);
        }
    }
}

