/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.pricing.dao;

import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.pricing.dao.ShippingRateDao;
import org.broadleafcommerce.pricing.domain.ShippingRate;
import org.broadleafcommerce.profile.domain.Address;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blShippingRatesDao")
public class ShippingRateDaoImpl
implements ShippingRateDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    public Address save(Address address) {
        if (address.getId() == null) {
            this.em.persist((Object)address);
        } else {
            address = (Address)this.em.merge((Object)address);
        }
        return address;
    }

    @Override
    public ShippingRate save(ShippingRate shippingRate) {
        if (shippingRate.getId() == null) {
            this.em.persist((Object)shippingRate);
        } else {
            shippingRate = (ShippingRate)this.em.merge((Object)shippingRate);
        }
        return shippingRate;
    }

    @Override
    public ShippingRate readShippingRateById(Long id) {
        return (ShippingRate)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.pricing.domain.ShippingRate"), (Object)id);
    }

    @Override
    public ShippingRate readShippingRateByFeeTypesUnityQty(String feeType, String feeSubType, BigDecimal unitQuantity) {
        Query query = this.em.createNamedQuery("BC_READ_FIRST_SHIPPING_RATE_BY_FEE_TYPES");
        query.setParameter("feeType", (Object)feeType);
        query.setParameter("feeSubType", (Object)feeSubType);
        query.setParameter("bandUnitQuantity", (Object)unitQuantity);
        List returnedRates = query.getResultList();
        if (returnedRates.size() > 0) {
            return (ShippingRate)returnedRates.get(0);
        }
        return null;
    }

    @Override
    public ShippingRate create() {
        return (ShippingRate)this.entityConfiguration.createEntityInstance(ShippingRate.class.getName());
    }
}

