/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.workflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.order.service.CartService;
import org.broadleafcommerce.payment.domain.PaymentInfo;
import org.broadleafcommerce.payment.domain.Referenced;
import org.broadleafcommerce.payment.service.SecurePaymentInfoService;
import org.broadleafcommerce.payment.service.workflow.CombinedPaymentContextSeed;
import org.broadleafcommerce.payment.service.workflow.PaymentActionType;
import org.broadleafcommerce.payment.service.workflow.PaymentSeed;
import org.broadleafcommerce.payment.service.workflow.WorkflowPaymentContext;
import org.broadleafcommerce.workflow.ProcessContext;
import org.broadleafcommerce.workflow.ProcessContextFactory;
import org.broadleafcommerce.workflow.WorkflowException;

public class PaymentProcessContextFactory
implements ProcessContextFactory {
    @Resource(name="blSecurePaymentInfoService")
    private SecurePaymentInfoService securePaymentInfoService;
    @Resource(name="blCartService")
    private CartService cartService;
    private PaymentActionType paymentActionType;

    @Override
    public ProcessContext createContext(Object seedData) throws WorkflowException {
        if (!(seedData instanceof PaymentSeed)) {
            throw new WorkflowException("Seed data instance is incorrect. Required class is " + PaymentSeed.class.getName() + " " + "but found class: " + seedData.getClass().getName());
        }
        PaymentSeed paymentSeed = (PaymentSeed)seedData;
        Map<PaymentInfo, Referenced> secureMap = paymentSeed.getInfos();
        if (secureMap == null) {
            secureMap = new HashMap<PaymentInfo, Referenced>();
            List<PaymentInfo> paymentInfoList = this.cartService.readPaymentInfosForOrder(paymentSeed.getOrder());
            if (paymentInfoList == null || paymentInfoList.size() == 0) {
                throw new WorkflowException("No payment info instances associated with the order -- id: " + paymentSeed.getOrder().getId());
            }
            for (PaymentInfo info : paymentInfoList) {
                secureMap.put(info, this.securePaymentInfoService.findSecurePaymentInfo(info.getReferenceNumber(), info.getType()));
            }
        }
        CombinedPaymentContextSeed combinedSeed = new CombinedPaymentContextSeed(secureMap, this.paymentActionType, paymentSeed.getOrder().getTotal(), paymentSeed.getPaymentResponse());
        WorkflowPaymentContext response = new WorkflowPaymentContext();
        response.setSeedData(combinedSeed);
        return response;
    }

    public PaymentActionType getPaymentActionType() {
        return this.paymentActionType;
    }

    public void setPaymentActionType(PaymentActionType paymentActionType) {
        this.paymentActionType = paymentActionType;
    }
}

