/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.workflow;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;

public class PaymentActionType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, PaymentActionType> types = new Hashtable<String, PaymentActionType>();
    public static PaymentActionType AUTHORIZE = new PaymentActionType("AUTHORIZE");
    public static PaymentActionType DEBIT = new PaymentActionType("DEBIT");
    public static PaymentActionType AUTHORIZEANDDEBIT = new PaymentActionType("AUTHORIZEANDDEBIT");
    public static PaymentActionType CREDIT = new PaymentActionType("CREDIT");
    public static PaymentActionType VOID = new PaymentActionType("VOID");
    public static PaymentActionType BALANCE = new PaymentActionType("BALANCE");
    private String type;

    public static PaymentActionType getInstance(String type) {
        return types.get(type);
    }

    public PaymentActionType() {
    }

    public PaymentActionType(String type) {
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        if (!types.containsKey(type)) {
            types.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaymentActionType other = (PaymentActionType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

