/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment.service.type;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;

public class TransactionType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, TransactionType> types = new Hashtable<String, TransactionType>();
    public static TransactionType AUTHORIZE = new TransactionType("AUTHORIZE");
    public static TransactionType DEBIT = new TransactionType("DEBIT");
    public static TransactionType AUTHORIZEANDDEBIT = new TransactionType("AUTHORIZEANDDEBIT");
    public static TransactionType CREDIT = new TransactionType("CREDIT");
    public static TransactionType VOIDPAYMENT = new TransactionType("VOIDPAYMENT");
    public static TransactionType BALANCE = new TransactionType("BALANCE");
    private String type;

    public static TransactionType getInstance(String type) {
        return types.get(type);
    }

    public TransactionType() {
    }

    public TransactionType(String type) {
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        if (!types.containsKey(type)) {
            types.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionType other = (TransactionType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

